/*
 * Decompiled with CFR 0.152.
 */
package org.csource_.common;

import java.io.IOException;
import java.util.Arrays;

public class Base64 {
    private String lineSeparator = System.getProperty("line.separator");
    private int lineLength = 72;
    private char[] valueToChar = new char[64];
    private int[] charToValue = new int[256];
    private int[] charToPad = new int[4];
    static final int IGNORE = -1;
    static final int PAD = -2;
    private static final boolean debug = true;

    public Base64() {
        this.init('+', '/', '=');
    }

    public Base64(char chPlus, char chSplash, char chPad, int lineLength) {
        this.init(chPlus, chSplash, chPad);
        this.lineLength = lineLength;
    }

    public Base64(int lineLength) {
        this.lineLength = lineLength;
    }

    private void init(char chPlus, char chSplash, char chPad) {
        int index = 0;
        int i = 65;
        while (i <= 90) {
            this.valueToChar[index++] = (char)i;
            ++i;
        }
        i = 97;
        while (i <= 122) {
            this.valueToChar[index++] = (char)i;
            ++i;
        }
        i = 48;
        while (i <= 57) {
            this.valueToChar[index++] = (char)i;
            ++i;
        }
        this.valueToChar[index++] = chPlus;
        this.valueToChar[index++] = chSplash;
        i = 0;
        while (i < 256) {
            this.charToValue[i] = -1;
            ++i;
        }
        i = 0;
        while (i < 64) {
            this.charToValue[this.valueToChar[i]] = i;
            ++i;
        }
        this.charToValue[chPad] = -2;
        Arrays.fill(this.charToPad, (int)chPad);
    }

    public String encode(byte[] b) throws IOException {
        int lines;
        int outputLength = (b.length + 2) / 3 * 4;
        if (this.lineLength != 0 && (lines = (outputLength + this.lineLength - 1) / this.lineLength - 1) > 0) {
            outputLength += lines * this.lineSeparator.length();
        }
        StringBuffer sb = new StringBuffer(outputLength);
        int linePos = 0;
        int len = b.length / 3 * 3;
        int leftover = b.length - len;
        int i = 0;
        while (i < len) {
            if ((linePos += 4) > this.lineLength) {
                if (this.lineLength != 0) {
                    sb.append(this.lineSeparator);
                }
                linePos = 4;
            }
            int combined = b[i + 0] & 0xFF;
            combined <<= 8;
            combined |= b[i + 1] & 0xFF;
            combined <<= 8;
            int c3 = (combined |= b[i + 2] & 0xFF) & 0x3F;
            int c2 = (combined >>>= 6) & 0x3F;
            int c1 = (combined >>>= 6) & 0x3F;
            int c0 = (combined >>>= 6) & 0x3F;
            sb.append(this.valueToChar[c0]);
            sb.append(this.valueToChar[c1]);
            sb.append(this.valueToChar[c2]);
            sb.append(this.valueToChar[c3]);
            i += 3;
        }
        switch (leftover) {
            default: {
                break;
            }
            case 1: {
                if ((linePos += 4) > this.lineLength) {
                    if (this.lineLength != 0) {
                        sb.append(this.lineSeparator);
                    }
                    linePos = 4;
                }
                byte[] byArray = new byte[3];
                byArray[0] = b[len];
                sb.append(this.encode(byArray).substring(0, 2));
                sb.append("==");
                break;
            }
            case 2: {
                if ((linePos += 4) > this.lineLength) {
                    if (this.lineLength != 0) {
                        sb.append(this.lineSeparator);
                    }
                    linePos = 4;
                }
                byte[] byArray = new byte[3];
                byArray[0] = b[len];
                byArray[1] = b[len + 1];
                sb.append(this.encode(byArray).substring(0, 3));
                sb.append("=");
            }
        }
        if (outputLength != sb.length()) {
            System.out.println("oops: minor program flaw: output length mis-estimated");
            System.out.println("estimate:" + outputLength);
            System.out.println("actual:" + sb.length());
        }
        return sb.toString();
    }

    public byte[] decodeAuto(String s) {
        int nRemain = s.length() % 4;
        if (nRemain == 0) {
            return this.decode(s);
        }
        return this.decode(String.valueOf(s) + new String(this.charToPad, 0, 4 - nRemain));
    }

    public byte[] decode(String s) {
        byte[] b = new byte[s.length() / 4 * 3];
        int cycle = 0;
        int combined = 0;
        int j = 0;
        int len = s.length();
        int dummies = 0;
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            int value = c <= '\u00ff' ? this.charToValue[c] : -1;
            block0 : switch (value) {
                case -1: {
                    break;
                }
                case -2: {
                    value = 0;
                    ++dummies;
                }
                default: {
                    switch (cycle) {
                        case 0: {
                            combined = value;
                            cycle = 1;
                            break block0;
                        }
                        case 1: {
                            combined <<= 6;
                            combined |= value;
                            cycle = 2;
                            break block0;
                        }
                        case 2: {
                            combined <<= 6;
                            combined |= value;
                            cycle = 3;
                            break block0;
                        }
                        case 3: {
                            combined <<= 6;
                            b[j + 2] = (byte)(combined |= value);
                            b[j + 1] = (byte)(combined >>>= 8);
                            b[j] = (byte)(combined >>>= 8);
                            j += 3;
                            cycle = 0;
                        }
                    }
                }
            }
            ++i;
        }
        if (cycle != 0) {
            throw new ArrayIndexOutOfBoundsException("Input to decode not an even multiple of 4 characters; pad with =.");
        }
        if (b.length != (j -= dummies)) {
            byte[] b2 = new byte[j];
            System.arraycopy(b, 0, b2, 0, j);
            b = b2;
        }
        return b;
    }

    public void setLineLength(int length) {
        this.lineLength = length / 4 * 4;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    /*
     * Unable to fully structure code
     */
    public static void show(byte[] b) {
        count = 0;
        rows = false;
        i = 0;
        while (i < b.length) {
            block3: {
                if (count != 8) break block3;
                System.out.print("  ");
                ** GOTO lbl-1000
            }
            if (count == 16) {
                System.out.println("");
                count = 0;
            } else lbl-1000:
            // 2 sources

            {
                System.out.print(String.valueOf(Integer.toHexString(b[i] & 255).toUpperCase()) + " ");
                ++count;
            }
            ++i;
        }
        System.out.println();
    }

    public static void display(byte[] b) {
        int i = 0;
        while (i < b.length) {
            System.out.print((char)b[i]);
            ++i;
        }
        System.out.println();
    }

    public static void main(String[] args) {
        Base64.test();
        System.exit(1);
        try {
            Base64 b64 = new Base64();
            String str = "agfrtu\ufffd\ufffdet\u02b21234\ufffd\u0674\ufffderty\ufffd\ufffd234\ufffd\ufffd\ufffd\ufffd2344\u02b2\ufffd\ufffd";
            String str64 = "";
            str64 = b64.encode(str.getBytes());
            System.out.println(str64);
            byte[] theBytes = b64.decode(str64);
            Base64.show(theBytes);
            String rst = new String(theBytes);
            System.out.println(rst);
            System.out.println(str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void test() {
        try {
            Base64 b64 = new Base64();
            String str64 = "CwUEFYoAAAADjQMC7ELJiY6w05267ELJiY6w05267ELJiY6w05267ELJiY6w05267ELJiY6w05267ELJiY6w05267ELJiY6w05267ELJiY6w05267ELJiY6w05267ELJiY6w05267ELJiY6w05267ELJiY6w05267ELJiY6w05267ELJiY6w05267EI=";
            byte[] theBytes = b64.decode(str64);
            Base64.show(theBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

