/*
 * Decompiled with CFR 0.152.
 */
package org.csource_.fastdfs;

import java.io.IOException;
import java.lang.reflect.Array;
import org.csource_.fastdfs.StructBase;

public class ProtoStructDecoder<T extends StructBase> {
    public T[] decode(byte[] bs, Class<T> clazz, int fieldsTotalSize) throws Exception {
        if (bs.length % fieldsTotalSize != 0) {
            throw new IOException("byte array length: " + bs.length + " is invalid!");
        }
        int count = bs.length / fieldsTotalSize;
        StructBase[] results = (StructBase[])Array.newInstance(clazz, count);
        int offset = 0;
        int i = 0;
        while (i < results.length) {
            results[i] = (StructBase)clazz.newInstance();
            results[i].setFields(bs, offset);
            offset += fieldsTotalSize;
            ++i;
        }
        return results;
    }
}

