/*
 * Decompiled with CFR 0.152.
 */
package org.csource_.fastdfs;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import org.csource_.fastdfs.ClientGlobal;
import org.csource_.fastdfs.ProtoCommon;

public abstract class StructBase {
    public abstract void setFields(byte[] var1, int var2);

    protected String stringValue(byte[] bs, int offset, FieldInfo filedInfo) {
        try {
            return new String(bs, offset + filedInfo.offset, filedInfo.size, ClientGlobal.g_charset).trim();
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected long longValue(byte[] bs, int offset, FieldInfo filedInfo) {
        return ProtoCommon.buff2long(bs, offset + filedInfo.offset);
    }

    protected int intValue(byte[] bs, int offset, FieldInfo filedInfo) {
        return (int)ProtoCommon.buff2long(bs, offset + filedInfo.offset);
    }

    protected byte byteValue(byte[] bs, int offset, FieldInfo filedInfo) {
        return bs[offset + filedInfo.offset];
    }

    protected boolean booleanValue(byte[] bs, int offset, FieldInfo filedInfo) {
        return bs[offset + filedInfo.offset] != 0;
    }

    protected Date dateValue(byte[] bs, int offset, FieldInfo filedInfo) {
        return new Date(ProtoCommon.buff2long(bs, offset + filedInfo.offset) * 1000L);
    }

    protected static class FieldInfo {
        protected String name;
        protected int offset;
        protected int size;

        public FieldInfo(String name, int offset, int size) {
            this.name = name;
            this.offset = offset;
            this.size = size;
        }
    }
}

