/*
 * Decompiled with CFR 0.152.
 */
package org.csource_.fastdfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.csource_.fastdfs.UploadCallback;

public class UploadStream
implements UploadCallback {
    private InputStream inputStream;
    private long fileSize = 0L;

    public UploadStream(InputStream inputStream, long fileSize) {
        this.inputStream = inputStream;
        this.fileSize = fileSize;
    }

    @Override
    public int send(OutputStream out) throws IOException {
        long remainBytes = this.fileSize;
        byte[] buff = new byte[262144];
        while (remainBytes > 0L) {
            int bytes;
            try {
                bytes = this.inputStream.read(buff, 0, remainBytes > (long)buff.length ? buff.length : (int)remainBytes);
                if (bytes < 0) {
                    return -1;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return -1;
            }
            out.write(buff, 0, bytes);
            remainBytes -= (long)bytes;
        }
        return 0;
    }
}

