/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ListUI;
import javax.swing.plaf.UIResource;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.substance.SubstanceDefaultListCellRenderer;
import org.jvnet.substance.SubstanceListUI;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;

public class SubstanceDefaultComboBoxRenderer
extends SubstanceDefaultListCellRenderer {
    private JComboBox combo;

    public SubstanceDefaultComboBoxRenderer(JComboBox combo) {
        this.combo = combo;
        Insets ins = SubstanceSizeUtils.getListCellRendererInsets(SubstanceSizeUtils.getComponentFontSize(combo));
        this.setBorder(new EmptyBorder(ins.top, ins.left, ins.bottom, ins.right));
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JComponent result = (JComponent)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        ListUI listUI = list.getUI();
        if (listUI instanceof SubstanceListUI) {
            SubstanceListUI ui = (SubstanceListUI)listUI;
            ComponentState state = ui.getCellState(index);
            ComponentState prevState = ui.getPrevCellState(index);
            if (index == -1) {
                boolean isEnabled = this.combo.isEnabled();
                if (isSelected && isEnabled) {
                    state = ComponentState.SELECTED;
                    prevState = ComponentState.SELECTED;
                }
                if (!isEnabled) {
                    state = ComponentState.DISABLED_UNSELECTED;
                    prevState = ComponentState.DISABLED_UNSELECTED;
                }
            }
            SubstanceTheme theme = SubstanceCoreUtilities.getTheme((Component)list, state, true, true);
            Color color = SubstanceCoreUtilities.getInterpolatedForegroundColor(list, Integer.valueOf(index), theme, state, prevState, FadeKind.SELECTION, FadeKind.ROLLOVER);
            result.setForeground(color);
        }
        result.setOpaque(!isSelected && index >= 0);
        return result;
    }

    public Dimension getPreferredSize() {
        Dimension size;
        if (this.getText() == null || this.getText().equals("")) {
            this.setText(" ");
            size = super.getPreferredSize();
            this.setText("");
        } else {
            size = super.getPreferredSize();
        }
        return size;
    }

    public static class SubstanceUIResource
    extends SubstanceDefaultComboBoxRenderer
    implements UIResource {
        public SubstanceUIResource(JComboBox combo) {
            super(combo);
        }
    }
}

