/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.View;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.painter.text.SubstanceTextPainter;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceLabelUI
extends BasicLabelUI {
    protected Set lafWidgets;
    private SubstanceFillBackgroundDelegate bgDelegate = new SubstanceFillBackgroundDelegate();
    private static final String ORIG_ICON = "substancelaf.internal.label.origIcon";
    private static final String REPLACING_ICON = "substancelaf.internal.label.replacingIcon";
    protected PropertyChangeListener substancePropertyChangeListener;

    public void installDefaults(JLabel jLabel) {
        this.__org__jvnet__substance__SubstanceLabelUI__installDefaults(jLabel);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    public void __org__jvnet__substance__SubstanceLabelUI__uninstallComponents(JLabel jLabel) {
        super.uninstallComponents(jLabel);
    }

    public void uninstallComponents(JLabel jLabel) {
        this.__org__jvnet__substance__SubstanceLabelUI__uninstallComponents(jLabel);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallComponents();
        }
    }

    public void uninstallDefaults(JLabel jLabel) {
        this.__org__jvnet__substance__SubstanceLabelUI__uninstallDefaults(jLabel);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public void update(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite && ((AlphaComposite)(object = (AlphaComposite)composite)).getRule() == 3) {
            f = ((AlphaComposite)object).getAlpha();
        }
        graphics2D.setComposite(TransitionLayout.getAlphaComposite((Component)jComponent, f));
        object = RenderingUtils.installDesktopHints(graphics2D);
        this.__org__jvnet__substance__SubstanceLabelUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
        if (object != null) {
            graphics2D.addRenderingHints((Map<?, ?>)object);
        }
    }

    public void __org__jvnet__substance__SubstanceLabelUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceLabelUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    public void uninstallListeners(JLabel jLabel) {
        this.__org__jvnet__substance__SubstanceLabelUI__uninstallListeners(jLabel);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public void __org__jvnet__substance__SubstanceLabelUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstanceLabelUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__jvnet__substance__SubstanceLabelUI__installComponents(JLabel jLabel) {
        super.installComponents(jLabel);
    }

    public void installComponents(JLabel jLabel) {
        this.__org__jvnet__substance__SubstanceLabelUI__installComponents(jLabel);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installComponents();
        }
    }

    public void installListeners(JLabel jLabel) {
        this.__org__jvnet__substance__SubstanceLabelUI__installListeners(jLabel);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    public static ComponentUI createUI(JComponent b) {
        return new SubstanceLabelUI();
    }

    protected void replaceThemedIcon(final JLabel label) {
        if (!SubstanceCoreUtilities.useThemedDefaultIcon(label)) {
            return;
        }
        final Icon icon = label.getIcon();
        if (icon != null && !Boolean.TRUE.equals(label.getClientProperty(REPLACING_ICON))) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    label.putClientProperty(SubstanceLabelUI.ORIG_ICON, label.getIcon());
                    label.putClientProperty(SubstanceLabelUI.REPLACING_ICON, Boolean.TRUE);
                    label.setIcon(new ImageIcon(SubstanceImageCreator.getThemeImage(label, icon, SubstanceCoreUtilities.getDefaultTheme(label, true), false)));
                    label.putClientProperty(SubstanceLabelUI.REPLACING_ICON, null);
                }
            });
        }
    }

    protected void __org__jvnet__substance__SubstanceLabelUI__installDefaults(JLabel c) {
        super.installDefaults(c);
        this.replaceThemedIcon(c);
    }

    protected void __org__jvnet__substance__SubstanceLabelUI__uninstallDefaults(JLabel c) {
        Icon origIcon = (Icon)c.getClientProperty(ORIG_ICON);
        if (origIcon != null) {
            c.putClientProperty(REPLACING_ICON, Boolean.TRUE);
            c.setIcon(origIcon);
            c.putClientProperty(REPLACING_ICON, null);
        }
        super.uninstallDefaults(c);
    }

    protected void __org__jvnet__substance__SubstanceLabelUI__installListeners(final JLabel c) {
        super.installListeners(c);
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("icon".equals(evt.getPropertyName())) {
                    SubstanceLabelUI.this.replaceThemedIcon(c);
                }
                if ("substancelaf.useThemedDefaultIcons".equals(evt.getPropertyName())) {
                    SubstanceLabelUI.this.replaceThemedIcon(c);
                }
                if ("opaque".equals(evt.getPropertyName()) && !Boolean.TRUE.equals(c.getClientProperty("substancelaf.lockopacity"))) {
                    c.putClientProperty("substancelaf.buttonopacityoriginal", evt.getNewValue());
                }
            }
        };
        c.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    protected void __org__jvnet__substance__SubstanceLabelUI__uninstallListeners(JLabel c) {
        c.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners(c);
    }

    public void paint(Graphics g, JComponent c) {
        Icon icon;
        JLabel label = (JLabel)c;
        String text = label.getText();
        Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        if (icon == null && text == null) {
            return;
        }
        Rectangle paintIconR = new Rectangle();
        Rectangle paintTextR = new Rectangle();
        Rectangle paintViewR = new Rectangle();
        Insets paintViewInsets = new Insets(0, 0, 0, 0);
        Insets insets = label.getInsets(paintViewInsets);
        paintViewR.x = insets.left;
        paintViewR.y = insets.top;
        paintViewR.width = c.getWidth() - (insets.left + insets.right);
        paintViewR.height = c.getHeight() - (insets.top + insets.bottom);
        paintIconR.height = 0;
        paintIconR.width = 0;
        paintIconR.y = 0;
        paintIconR.x = 0;
        paintTextR.height = 0;
        paintTextR.width = 0;
        paintTextR.y = 0;
        paintTextR.x = 0;
        String clippedText = SwingUtilities.layoutCompoundLabel(label, g.getFontMetrics(), text, icon, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), paintViewR, paintIconR, paintTextR, label.getIconTextGap());
        SubstanceTextPainter textPainter = SubstanceLookAndFeel.getCurrentTextPainter();
        Graphics2D g2d = (Graphics2D)g.create();
        if (textPainter.needsBackgroundImage()) {
            Color color = label.isOpaque() || label.getParent() == null ? label.getBackground() : label.getParent().getBackground();
            textPainter.setBackgroundImage(label, null, color, true, 0, 0, new SubstanceTextPainter.ImageBackgroundPaintingCallback(null, null, 1.0f));
        } else {
            this.bgDelegate.updateIfOpaque(g2d, c);
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g2d, paintTextR);
            } else {
                Color fg = label.isEnabled() ? label.getForeground() : UIManager.getColor("Label.disabledText");
                g2d.setColor(fg);
                textPainter.paintText(g2d, label, paintTextR, clippedText, label.getDisplayedMnemonicIndex());
            }
        }
        if (icon != null) {
            icon.paintIcon(c, g2d, paintIconR.x, paintIconR.y);
        }
        g2d.dispose();
    }

    public void __org__jvnet__substance__SubstanceLabelUI__update(Graphics g, JComponent c) {
        if (!(UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel)) {
            return;
        }
        this.paint(g, c);
    }
}

