/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import javax.swing.text.View;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.lafwidget.animation.FadeStateListener;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.painter.text.SubstanceTextPainter;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.RolloverButtonListener;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceFadeUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;

public class SubstanceRadioButtonUI
extends BasicRadioButtonUI {
    protected Set lafWidgets;
    private SubstanceFillBackgroundDelegate bgDelegate = new SubstanceFillBackgroundDelegate();
    protected PropertyChangeListener substancePropertyListener;
    protected JToggleButton button;
    private static Map<String, Icon> icons = new HashMap<String, Icon>();
    protected FadeStateListener substanceFadeStateListener;

    public void installDefaults(AbstractButton abstractButton) {
        this.__org__jvnet__substance__SubstanceRadioButtonUI__installDefaults(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    public void uninstallDefaults(AbstractButton abstractButton) {
        this.__org__jvnet__substance__SubstanceRadioButtonUI__uninstallDefaults(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public void __org__jvnet__substance__SubstanceRadioButtonUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite && ((AlphaComposite)(object = (AlphaComposite)composite)).getRule() == 3) {
            f = ((AlphaComposite)object).getAlpha();
        }
        graphics2D.setComposite(TransitionLayout.getAlphaComposite((Component)jComponent, f));
        object = RenderingUtils.installDesktopHints(graphics2D);
        this.__org__jvnet__substance__SubstanceRadioButtonUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
        if (object != null) {
            graphics2D.addRenderingHints((Map<?, ?>)object);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceRadioButtonUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    public void uninstallListeners(AbstractButton abstractButton) {
        this.__org__jvnet__substance__SubstanceRadioButtonUI__uninstallListeners(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstanceRadioButtonUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void installListeners(AbstractButton abstractButton) {
        this.__org__jvnet__substance__SubstanceRadioButtonUI__installListeners(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    public static synchronized void reset() {
        icons.clear();
    }

    protected void __org__jvnet__substance__SubstanceRadioButtonUI__installListeners(final AbstractButton b) {
        super.installListeners(b);
        this.substanceFadeStateListener = new FadeStateListener(b, b.getModel(), SubstanceCoreUtilities.getFadeCallback(b));
        this.substanceFadeStateListener.registerListeners();
        this.substancePropertyListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("model".equals(evt.getPropertyName())) {
                    if (SubstanceRadioButtonUI.this.substanceFadeStateListener != null) {
                        SubstanceRadioButtonUI.this.substanceFadeStateListener.unregisterListeners();
                    }
                    SubstanceRadioButtonUI.this.substanceFadeStateListener = new FadeStateListener(b, b.getModel(), SubstanceCoreUtilities.getFadeCallback(b));
                    SubstanceRadioButtonUI.this.substanceFadeStateListener.registerListeners();
                }
                if ("opaque".equals(evt.getPropertyName()) && !Boolean.TRUE.equals(b.getClientProperty("substancelaf.lockopacity"))) {
                    b.putClientProperty("substancelaf.buttonopacityoriginal", evt.getNewValue());
                }
            }
        };
        b.addPropertyChangeListener(this.substancePropertyListener);
    }

    protected void __org__jvnet__substance__SubstanceRadioButtonUI__installDefaults(AbstractButton b) {
        super.installDefaults(b);
        Border border = b.getBorder();
        if (border == null || border instanceof UIResource) {
            b.setBorder(SubstanceSizeUtils.getRadioButtonBorder(SubstanceSizeUtils.getComponentFontSize(b)));
        }
    }

    protected void __org__jvnet__substance__SubstanceRadioButtonUI__uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
    }

    public void __org__jvnet__substance__SubstanceRadioButtonUI__installUI(JComponent c) {
        super.installUI(c);
    }

    public void __org__jvnet__substance__SubstanceRadioButtonUI__uninstallUI(JComponent c) {
        super.uninstallUI(c);
    }

    protected void __org__jvnet__substance__SubstanceRadioButtonUI__uninstallListeners(AbstractButton b) {
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
        b.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        super.uninstallListeners(b);
    }

    private static synchronized Icon getIcon(JToggleButton button, ComponentState currState, ComponentState prevState) {
        int checkMarkSize;
        String key;
        Icon result;
        float visibility = currState.isKindActive(FadeKind.SELECTION) ? 10.0f : 0.0f;
        SubstanceTheme theme = SubstanceCoreUtilities.getTheme((Component)button, currState, true, true);
        SubstanceTheme theme2 = SubstanceCoreUtilities.getTheme((Component)button, prevState, true, true);
        float cyclePos = 0.0f;
        FadeState fadeState = SubstanceFadeUtilities.getFadeState((Component)button, FadeKind.SELECTION, FadeKind.ROLLOVER, FadeKind.PRESS);
        if (fadeState != null) {
            cyclePos = fadeState.getFadePosition();
            if (fadeState.isFadingIn()) {
                cyclePos = 10.0f - cyclePos;
            }
            if (fadeState.fadeKind == FadeKind.SELECTION) {
                visibility = fadeState.getFadePosition();
            }
        }
        if ((result = icons.get(key = (checkMarkSize = SubstanceSizeUtils.getRadioButtonMarkSize(SubstanceSizeUtils.getComponentFontSize(button))) + ":" + currState.name() + ":" + currState.name() + ":" + theme.getDisplayName() + ":" + theme2.getDisplayName() + ":" + cyclePos + ":" + visibility)) != null) {
            return result;
        }
        result = new ImageIcon(SubstanceImageCreator.getRadioButton(button, checkMarkSize, currState, 0, theme, theme2, cyclePos, visibility / 10.0f));
        icons.put(key, result);
        return result;
    }

    public static ComponentUI createUI(JComponent b) {
        return new SubstanceRadioButtonUI((JToggleButton)b);
    }

    public SubstanceRadioButtonUI(JToggleButton button) {
        this.button = button;
        button.setRolloverEnabled(true);
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new RolloverButtonListener(b);
    }

    public Icon getDefaultIcon() {
        ButtonModel model = this.button.getModel();
        ComponentState currState = ComponentState.getState(model, this.button);
        ComponentState prevState = SubstanceCoreUtilities.getPrevComponentState(this.button);
        return SubstanceRadioButtonUI.getIcon(this.button, currState, prevState);
    }

    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        boolean isOpaque = c.isOpaque();
        c.putClientProperty("substancelaf.lockopacity", Boolean.TRUE);
        c.setOpaque(false);
        if (isOpaque || TransitionLayout.isOpaque(c)) {
            this.bgDelegate.update(g, c);
        }
        c.setOpaque(isOpaque);
        c.putClientProperty("substancelaf.lockopacity", null);
        SubstanceTextPainter textPainter = SubstanceLookAndFeel.getCurrentTextPainter();
        if (textPainter.needsBackgroundImage()) {
            textPainter.setBackgroundImage(b, null, b.getBackground(), true, 0, 0, null);
        }
        FontMetrics fm = g.getFontMetrics();
        Insets i = c.getInsets();
        Rectangle viewRect = new Rectangle();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        viewRect.x = i.left;
        viewRect.y = i.top;
        viewRect.width = b.getWidth() - (i.right + viewRect.x);
        viewRect.height = b.getHeight() - (i.bottom + viewRect.y);
        textRect.height = 0;
        textRect.width = 0;
        textRect.y = 0;
        textRect.x = 0;
        iconRect.height = 0;
        iconRect.width = 0;
        iconRect.y = 0;
        iconRect.x = 0;
        Font f = c.getFont();
        g.setFont(f);
        Icon icon = SubstanceCoreUtilities.getIcon(b, this.getDefaultIcon(), null, false);
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), icon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        if (text != null && !text.equals("")) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
        if (icon != null) {
            icon.paintIcon(c, g, iconRect.x, iconRect.y);
        }
        if (b.isFocusPainted() && (b.hasFocus() || FadeTracker.getInstance().isTracked(c, FadeKind.FOCUS))) {
            SubstanceCoreUtilities.paintFocus(g, this.button, this.button, null, textRect, 1.0f, 1);
        }
    }

    public static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceRadioButtonUI: \n");
        sb.append("\t" + icons.size() + " icons");
        return sb.toString();
    }

    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        SubstanceCoreUtilities.paintText(g, (AbstractButton)c, textRect, text);
    }
}

