/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.View;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.animation.FadeStateListener;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.SubstanceBorder;
import org.jvnet.substance.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.text.SubstancePlainView;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;

public class SubstanceTextFieldUI
extends BasicTextFieldUI {
    protected Set lafWidgets;
    protected FadeStateListener substanceFadeStateListener;
    protected JTextField textField;
    private static SubstanceFillBackgroundDelegate bgDelegate = new SubstanceFillBackgroundDelegate(0.6f);
    protected PropertyChangeListener substancePropertyChangeListener;

    public void installDefaults() {
        this.__org__jvnet__substance__SubstanceTextFieldUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    public void __org__jvnet__substance__SubstanceTextFieldUI__uninstallDefaults() {
        super.uninstallDefaults();
    }

    public void uninstallDefaults() {
        this.__org__jvnet__substance__SubstanceTextFieldUI__uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public void __org__jvnet__substance__SubstanceTextFieldUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite && ((AlphaComposite)(object = (AlphaComposite)composite)).getRule() == 3) {
            f = ((AlphaComposite)object).getAlpha();
        }
        graphics2D.setComposite(TransitionLayout.getAlphaComposite((Component)jComponent, f));
        object = RenderingUtils.installDesktopHints(graphics2D);
        this.__org__jvnet__substance__SubstanceTextFieldUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
        if (object != null) {
            graphics2D.addRenderingHints((Map<?, ?>)object);
        }
    }

    public void __org__jvnet__substance__SubstanceTextFieldUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceTextFieldUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    public void uninstallListeners() {
        this.__org__jvnet__substance__SubstanceTextFieldUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public void __org__jvnet__substance__SubstanceTextFieldUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstanceTextFieldUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void installListeners() {
        this.__org__jvnet__substance__SubstanceTextFieldUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceTextFieldUI(c);
    }

    public SubstanceTextFieldUI(JComponent c) {
        this.textField = (JTextField)c;
    }

    protected void paintBackground(Graphics g) {
        if (SubstanceCoreUtilities.hasSubstanceBorder(this.getComponent())) {
            g.setColor(this.getComponent().getBackground());
            g.fillRect(1, 1, this.getComponent().getWidth() - 2, this.getComponent().getHeight() - 2);
        } else {
            super.paintBackground(g);
        }
        if (SubstanceCoreUtilities.toBleedWatermark(this.textField)) {
            bgDelegate.updateIfOpaque(g, this.textField);
        }
    }

    protected void __org__jvnet__substance__SubstanceTextFieldUI__installListeners() {
        super.installListeners();
        this.substanceFadeStateListener = new FadeStateListener(this.textField, null, null);
        this.substanceFadeStateListener.registerListeners(false);
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("font".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SubstanceTextFieldUI.this.textField.updateUI();
                        }
                    });
                }
            }
        };
        this.textField.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    protected void __org__jvnet__substance__SubstanceTextFieldUI__uninstallListeners() {
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
        this.textField.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners();
    }

    protected void __org__jvnet__substance__SubstanceTextFieldUI__installDefaults() {
        super.installDefaults();
        Border b = this.textField.getBorder();
        if (b == null || b instanceof UIResource) {
            BorderUIResource.CompoundBorderUIResource newB = new BorderUIResource.CompoundBorderUIResource(new SubstanceBorder(SubstanceSizeUtils.getTextBorderInsets(SubstanceSizeUtils.getComponentFontSize(this.textField))), new BasicBorders.MarginBorder());
            this.textField.setBorder(newB);
        }
    }

    public View create(Element elem) {
        View superResult = super.create(elem);
        if (superResult instanceof PlainView) {
            return new SubstancePlainView(elem);
        }
        return superResult;
    }
}

