/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.button;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.geom.GeneralPath;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.border.Border;
import org.jvnet.substance.SubstanceButtonBorder;
import org.jvnet.substance.button.BaseButtonShaper;
import org.jvnet.substance.button.RectangularButtonShaper;
import org.jvnet.substance.combo.SubstanceComboBoxButton;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;

public class ClassicButtonShaper
extends BaseButtonShaper
implements RectangularButtonShaper {
    public String getDisplayName() {
        return "Classic";
    }

    public GeneralPath getButtonOutline(AbstractButton button, Insets insets, int width, int height) {
        Set<SubstanceConstants.Side> straightSides = SubstanceCoreUtilities.getSides(button, "substancelaf.buttonside");
        float radius = this.getCornerRadius(button, insets);
        return ClassicButtonShaper.getBaseOutline(width, height, radius, straightSides, insets);
    }

    public Border getButtonBorder(AbstractButton button) {
        return new SubstanceButtonBorder(ClassicButtonShaper.class){

            public Insets getBorderInsets(Component c) {
                int extraPadding = SubstanceSizeUtils.getExtraPadding(SubstanceSizeUtils.getComponentFontSize(c));
                if (c instanceof SubstanceComboBoxButton) {
                    return new Insets(extraPadding, extraPadding, extraPadding, extraPadding);
                }
                return new Insets(2 + extraPadding, 3 + extraPadding, 2 + extraPadding, 3 + extraPadding);
            }
        };
    }

    public Dimension getPreferredSize(AbstractButton button, Dimension uiPreferredSize) {
        boolean toTweakWidth = false;
        boolean toTweakHeight = false;
        Icon icon = button.getIcon();
        boolean hasIcon = SubstanceCoreUtilities.hasIcon(button);
        boolean hasText = SubstanceCoreUtilities.hasText(button);
        Insets margin = button.getMargin();
        Dimension result = uiPreferredSize;
        boolean hasNoMinSizeProperty = SubstanceCoreUtilities.hasNoMinSizeProperty(button);
        if (!hasNoMinSizeProperty && hasText) {
            int baseWidth = uiPreferredSize.width;
            baseWidth = Math.max(baseWidth, SubstanceSizeUtils.getMinButtonWidth(SubstanceSizeUtils.getComponentFontSize(button)));
            result = new Dimension(baseWidth, uiPreferredSize.height);
            int baseHeight = result.height;
            baseHeight = Math.max(baseHeight, SubstanceSizeUtils.getMinButtonHeight(SubstanceSizeUtils.getComponentFontSize(button)));
            result = new Dimension(result.width, baseHeight);
        } else if (hasNoMinSizeProperty && margin != null) {
            result = new Dimension(result.width + margin.left + margin.right, result.height + margin.top + margin.bottom);
        }
        int extraPadding = SubstanceSizeUtils.getExtraPadding(SubstanceSizeUtils.getComponentFontSize(button));
        int iconPaddingWidth = 6 + 2 * extraPadding;
        int iconPaddingHeight = 6 + 2 * extraPadding;
        if (margin != null) {
            iconPaddingWidth = Math.max(iconPaddingWidth, margin.left + margin.right);
            iconPaddingHeight = Math.max(iconPaddingHeight, margin.top + margin.bottom);
        }
        if (hasIcon) {
            int iconWidth;
            int iconHeight = icon.getIconHeight();
            if ((double)iconHeight > result.getHeight() - (double)iconPaddingHeight) {
                result = new Dimension(result.width, iconHeight);
                toTweakHeight = true;
            }
            if ((double)(iconWidth = icon.getIconWidth()) > result.getWidth() - (double)iconPaddingWidth) {
                result = new Dimension(iconWidth, result.height);
                toTweakWidth = true;
            }
        }
        if (SubstanceCoreUtilities.isScrollBarButton(button)) {
            toTweakWidth = false;
            toTweakHeight = false;
        }
        if (toTweakWidth) {
            result = new Dimension(result.width + iconPaddingWidth, result.height);
        }
        if (toTweakHeight) {
            result = new Dimension(result.width, result.height + iconPaddingHeight);
        }
        return result;
    }

    public boolean isProportionate() {
        return true;
    }

    public float getCornerRadius(AbstractButton button, Insets insets) {
        int max;
        float radius = SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(button));
        if (SubstanceCoreUtilities.isToolBarButton(button)) {
            radius = SubstanceCoreUtilities.getToolbarButtonCornerRadius(button, insets);
        } else if (insets != null && (max = Math.max(Math.max(insets.left, insets.right), Math.max(insets.top, insets.bottom))) >= 2) {
            radius = 1.0f;
        }
        return radius;
    }
}

