/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.painter.text;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.painter.text.SubstanceTextPainter;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTextPainter
implements SubstanceTextPainter {
    @Override
    public boolean needsBackgroundImage() {
        return false;
    }

    @Override
    public void paintText(Graphics graphics, JComponent comp, Rectangle textRect, String text, int mnemonicIndex) {
        Graphics2D g2d = (Graphics2D)graphics.create();
        SubstanceCoreUtilities.workaroundBug6576507(g2d);
        RenderingUtils.installDesktopHints(g2d);
        BasicGraphicsUtils.drawStringUnderlineCharAt(g2d, text, mnemonicIndex, textRect.x, textRect.y + g2d.getFontMetrics().getAscent());
        g2d.dispose();
    }

    @Override
    public void paintText(Graphics graphics, JComponent comp, Iterable<SubstanceTextPainter.TextLineInfo> textLines) {
        Graphics2D g2d = (Graphics2D)graphics.create();
        SubstanceCoreUtilities.workaroundBug6576507(g2d);
        RenderingUtils.installDesktopHints(g2d);
        for (SubstanceTextPainter.TextLineInfo lineInfo : textLines) {
            BasicGraphicsUtils.drawStringUnderlineCharAt(g2d, lineInfo.text, lineInfo.mnemonicIndex, lineInfo.textRect.x, lineInfo.textRect.y + g2d.getFontMetrics().getAscent());
        }
        g2d.dispose();
    }

    @Override
    public void setBackgroundImage(JComponent comp, Rectangle clip, Color backgroundFillColor, boolean toOverlayWatermark, int watermarkOffsetX, int watermarkOffsetY, SubstanceTextPainter.BackgroundPaintingCallback backgroundPaintingCallback) {
    }
}

