/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.painter.text;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface SubstanceTextPainter {
    public boolean needsBackgroundImage();

    public void setBackgroundImage(JComponent var1, Rectangle var2, Color var3, boolean var4, int var5, int var6, BackgroundPaintingCallback var7);

    public void paintText(Graphics var1, JComponent var2, Rectangle var3, String var4, int var5);

    public void paintText(Graphics var1, JComponent var2, Iterable<TextLineInfo> var3);

    public static class ImageBackgroundPaintingCallback
    implements BackgroundPaintingCallback {
        BufferedImage backgroundImage;
        Point backgroundImageAnchor;
        float alpha;

        public ImageBackgroundPaintingCallback(BufferedImage backgroundImage, Point backgroundImageAnchor, float alpha) {
            this.backgroundImage = backgroundImage;
            this.backgroundImageAnchor = backgroundImageAnchor;
            this.alpha = alpha;
        }

        public void paintBackground(Graphics g) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setComposite(AlphaComposite.getInstance(3, this.alpha));
            if (this.backgroundImageAnchor == null) {
                g2d.drawImage((Image)this.backgroundImage, 0, 0, null);
            } else {
                g2d.drawImage((Image)this.backgroundImage, this.backgroundImageAnchor.x, this.backgroundImageAnchor.y, null);
            }
            g2d.dispose();
        }
    }

    public static interface BackgroundPaintingCallback {
        public void paintBackground(Graphics var1);
    }

    public static class TextLineInfo {
        public Rectangle textRect;
        public String text;
        public int mnemonicIndex;

        public TextLineInfo(Rectangle textRect, String text, int mnemonicIndex) {
            this.textRect = textRect;
            this.text = text;
            this.mnemonicIndex = mnemonicIndex;
        }
    }
}

