/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.text;

import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.View;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.painter.text.SubstanceTextPainter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextUtilities {
    private static JComponent getJComponent(View view) {
        Container component;
        if (view != null && (component = view.getContainer()) instanceof JComponent) {
            return (JComponent)component;
        }
        return null;
    }

    public static int drawTabbedText(View view, Segment s, int x, int y, Graphics g, TabExpander e, int startOffset) {
        SubstanceTextPainter textPainter;
        JComponent component = TextUtilities.getJComponent(view);
        FontMetrics metrics = g.getFontMetrics();
        int nextX = x;
        char[] txt = s.array;
        int txtOffset = s.offset;
        int flushLen = 0;
        int flushIndex = s.offset;
        int spaceAddon = 0;
        int spaceAddonLeftoverEnd = -1;
        int startJustifiableContent = 0;
        int endJustifiableContent = 0;
        int n = s.offset + s.count;
        HashSet<SubstanceTextPainter.TextLineInfo> textLines = new HashSet<SubstanceTextPainter.TextLineInfo>();
        for (int i = txtOffset; i < n; ++i) {
            if (txt[i] == '\t' || (spaceAddon != 0 || i <= spaceAddonLeftoverEnd) && txt[i] == ' ' && startJustifiableContent <= i && i <= endJustifiableContent) {
                if (flushLen > 0) {
                    nextX = TextUtilities.drawChars(component, g, txt, flushIndex, flushLen, x, y, textLines);
                    flushLen = 0;
                }
                flushIndex = i + 1;
                if (txt[i] == '\t') {
                    nextX = e != null ? (int)e.nextTabStop(nextX, startOffset + i - txtOffset) : (nextX += metrics.charWidth(' '));
                } else if (txt[i] == ' ') {
                    nextX += metrics.charWidth(' ') + spaceAddon;
                    if (i <= spaceAddonLeftoverEnd) {
                        // empty if block
                    }
                }
                x = ++nextX;
                continue;
            }
            if (txt[i] == '\n' || txt[i] == '\r') {
                if (flushLen > 0) {
                    nextX = TextUtilities.drawChars(component, g, txt, flushIndex, flushLen, x, y, textLines);
                    flushLen = 0;
                }
                flushIndex = i + 1;
                x = nextX;
                continue;
            }
            ++flushLen;
        }
        if (flushLen > 0) {
            nextX = TextUtilities.drawChars(component, g, txt, flushIndex, flushLen, x, y, textLines);
        }
        if ((textPainter = SubstanceLookAndFeel.getCurrentTextPainter()).needsBackgroundImage()) {
            textPainter.setBackgroundImage(component, null, component.getBackground(), false, 0, 0, null);
        }
        Graphics2D g2d = (Graphics2D)g.create();
        textPainter.paintText(g2d, component, textLines);
        g2d.dispose();
        return nextX;
    }

    public static int drawChars(JComponent c, Graphics g, char[] data, int offset, int length, int x, int y, Set<SubstanceTextPainter.TextLineInfo> textLines) {
        if (length <= 0) {
            return x;
        }
        FontMetrics fm = g.getFontMetrics();
        int nextX = x + g.getFontMetrics().charsWidth(data, offset, length);
        textLines.add(new SubstanceTextPainter.TextLineInfo(new Rectangle(x, y - fm.getAscent(), nextX - x, fm.getHeight()), new String(data, offset, length), -1));
        return nextX;
    }
}

