/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.substance.button.BaseButtonShaper;
import org.jvnet.substance.button.SubstanceButtonShaper;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;

public class SubstanceConstants {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TabContentPaneBorderKind {
        DOUBLE_FULL,
        SINGLE_FULL,
        DOUBLE_PLACEMENT,
        SINGLE_PLACEMENT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ColorShiftKind {
        SHADE,
        TINT,
        TONE,
        THEME_LIGHT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MenuGutterFillKind {
        NONE,
        SOFT_FILL,
        HARD_FILL,
        SOFT,
        HARD;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScrollPaneButtonPolicyKind {
        NONE,
        OPPOSITE,
        ADJACENT,
        MULTIPLE,
        MULTIPLE_BOTH;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TabTextAlignmentKind {
        DEFAULT,
        ALWAYS_LEFT,
        ALWAYS_RIGHT,
        FOLLOW_PLACEMENT,
        FOLLOW_ORIENTATION;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TabCloseKind {
        NONE,
        THIS,
        ALL,
        ALL_BUT_THIS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImageWatermarkKind {
        SCREEN_CENTER_SCALE,
        SCREEN_TILE,
        APP_ANCHOR,
        APP_CENTER,
        APP_TILE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FocusKind {
        NONE{

            public void paintFocus(Component mainComp, Component focusedComp, Graphics2D graphics, Rectangle focusRect, Rectangle textRect, int extraPadding) {
            }
        }
        ,
        TEXT{

            public void paintFocus(Component mainComp, Component focusedComp, Graphics2D graphics, Rectangle focusRect, Rectangle textRect, int extraPadding) {
                if (textRect == null) {
                    return;
                }
                float dashPhase = 0.0f;
                int fontSize = SubstanceSizeUtils.getComponentFontSize(mainComp);
                float dashLength = 2.getDashLength(fontSize);
                float dashGap = 2.getDashGap(fontSize);
                FadeTracker fadeTracker = FadeTracker.getInstance();
                if (fadeTracker.isTracked(focusedComp, FadeKind.FOCUS_LOOP_ANIMATION)) {
                    dashPhase = (dashLength + dashGap) * (1.0f - fadeTracker.getFade10(focusedComp, FadeKind.FOCUS_LOOP_ANIMATION) / 10.0f);
                }
                graphics.setStroke(new BasicStroke(SubstanceSizeUtils.getFocusStrokeWidth(fontSize), 0, 1, 0.0f, new float[]{dashLength, dashGap}, dashPhase));
                int delta = mainComp instanceof JComboBox || mainComp instanceof JSpinner ? 0 : 1;
                GeneralPath contour = BaseButtonShaper.getBaseOutline(textRect.width + 2 * delta, textRect.height, 2.0f, null);
                graphics.translate(textRect.x - delta, textRect.y);
                graphics.draw(contour);
            }

            public boolean isAnimated() {
                return true;
            }
        }
        ,
        ALL{

            public void paintFocus(Component mainComp, Component focusedComp, Graphics2D graphics, Rectangle focusRect, Rectangle textRect, int extraPadding) {
                if (focusRect == null && mainComp instanceof AbstractButton && !(mainComp instanceof JCheckBox) && !(mainComp instanceof JRadioButton)) {
                    SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper((AbstractButton)mainComp);
                    if (shaper == null) {
                        return;
                    }
                    float dashPhase = 0.0f;
                    int fontSize = SubstanceSizeUtils.getComponentFontSize(mainComp);
                    float dashLength = 3.getDashLength(fontSize);
                    float dashGap = 3.getDashGap(fontSize);
                    FadeTracker fadeTracker = FadeTracker.getInstance();
                    if (fadeTracker.isTracked(focusedComp, FadeKind.FOCUS_LOOP_ANIMATION)) {
                        dashPhase = (dashLength + dashGap) * (1.0f - fadeTracker.getFade10(focusedComp, FadeKind.FOCUS_LOOP_ANIMATION) / 10.0f);
                    }
                    graphics.setStroke(new BasicStroke(SubstanceSizeUtils.getFocusStrokeWidth(fontSize), 0, 1, 0.0f, new float[]{dashLength, dashGap}, dashPhase));
                    GeneralPath contour = shaper.getButtonOutline((AbstractButton)mainComp, null);
                    graphics.draw(contour);
                } else {
                    graphics.translate(1, 1);
                    Rectangle contour = focusRect != null ? focusRect : BaseButtonShaper.getBaseOutline(mainComp.getWidth() - 2, mainComp.getHeight() - 2, 3.0f, null);
                    float dashPhase = 0.0f;
                    int fontSize = SubstanceSizeUtils.getComponentFontSize(mainComp);
                    float dashLength = 3.getDashLength(fontSize);
                    float dashGap = 3.getDashGap(fontSize);
                    FadeTracker fadeTracker = FadeTracker.getInstance();
                    if (fadeTracker.isTracked(focusedComp, FadeKind.FOCUS_LOOP_ANIMATION)) {
                        dashPhase = (dashLength + dashGap) * (1.0f - fadeTracker.getFade10(focusedComp, FadeKind.FOCUS_LOOP_ANIMATION) / 10.0f);
                    }
                    graphics.setStroke(new BasicStroke(SubstanceSizeUtils.getFocusStrokeWidth(fontSize), 0, 1, 0.0f, new float[]{dashLength, dashGap}, dashPhase));
                    graphics.draw(contour);
                }
            }

            public boolean isAnimated() {
                return true;
            }
        }
        ,
        ALL_INNER{

            public void paintFocus(Component mainComp, Component focusedComp, Graphics2D graphics, Rectangle focusRect, Rectangle textRect, int extraPadding) {
                if (focusRect == null && mainComp instanceof AbstractButton && !(mainComp instanceof JCheckBox) && !(mainComp instanceof JRadioButton)) {
                    SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper((AbstractButton)mainComp);
                    if (shaper == null) {
                        return;
                    }
                    if (shaper.isProportionate()) {
                        float dashPhase = 0.0f;
                        int fontSize = SubstanceSizeUtils.getComponentFontSize(mainComp);
                        float dashLength = 4.getDashLength(fontSize);
                        float dashGap = 4.getDashGap(fontSize);
                        FadeTracker fadeTracker = FadeTracker.getInstance();
                        if (fadeTracker.isTracked(focusedComp, FadeKind.FOCUS_LOOP_ANIMATION)) {
                            dashPhase = (dashLength + dashGap) * (1.0f - fadeTracker.getFade10(focusedComp, FadeKind.FOCUS_LOOP_ANIMATION) / 10.0f);
                        }
                        graphics.setStroke(new BasicStroke(SubstanceSizeUtils.getFocusStrokeWidth(fontSize), 0, 1, 0.0f, new float[]{dashLength, dashGap}, dashPhase));
                        Insets insets = new Insets(extraPadding, extraPadding, extraPadding, extraPadding);
                        GeneralPath contour = shaper.getButtonOutline((AbstractButton)mainComp, insets);
                        graphics.draw(contour);
                    }
                } else {
                    graphics.translate(extraPadding, extraPadding);
                    Rectangle contour = focusRect != null ? focusRect : BaseButtonShaper.getBaseOutline(mainComp.getWidth() - 2 * extraPadding, mainComp.getHeight() - 2 * extraPadding, 2.0f, null);
                    float dashPhase = 0.0f;
                    int fontSize = SubstanceSizeUtils.getComponentFontSize(mainComp);
                    float dashLength = 4.getDashLength(fontSize);
                    float dashGap = 4.getDashGap(fontSize);
                    FadeTracker fadeTracker = FadeTracker.getInstance();
                    if (fadeTracker.isTracked(focusedComp, FadeKind.FOCUS_LOOP_ANIMATION)) {
                        dashPhase = (dashLength + dashGap) * (1.0f - fadeTracker.getFade10(focusedComp, FadeKind.FOCUS_LOOP_ANIMATION) / 10.0f);
                    }
                    graphics.setStroke(new BasicStroke(SubstanceSizeUtils.getFocusStrokeWidth(fontSize), 0, 1, 0.0f, new float[]{dashLength, dashGap}, dashPhase));
                    graphics.draw(contour);
                }
            }

            public boolean isAnimated() {
                return true;
            }
        }
        ,
        ALL_STRONG_INNER{

            public void paintFocus(Component mainComp, Component focusedComp, Graphics2D graphics, Rectangle focusRect, Rectangle textRect, int extraPadding) {
                if (focusRect == null && mainComp instanceof AbstractButton && !(mainComp instanceof JCheckBox) && !(mainComp instanceof JRadioButton)) {
                    SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper((AbstractButton)mainComp);
                    if (shaper == null) {
                        return;
                    }
                    if (shaper.isProportionate()) {
                        Insets insets = new Insets(extraPadding, extraPadding, extraPadding, extraPadding);
                        GeneralPath contour = shaper.getButtonOutline((AbstractButton)mainComp, insets);
                        graphics.draw(contour);
                    }
                } else {
                    graphics.translate(extraPadding, extraPadding);
                    Rectangle contour = focusRect != null ? focusRect : BaseButtonShaper.getBaseOutline(mainComp.getWidth() - 2 * extraPadding, mainComp.getHeight() - 2 * extraPadding, 2.0f, null);
                    graphics.draw(contour);
                }
            }
        }
        ,
        UNDERLINE{

            public void paintFocus(Component mainComp, Component focusedComp, Graphics2D graphics, Rectangle focusRect, Rectangle textRect, int extraPadding) {
                if (textRect == null) {
                    return;
                }
                float dashPhase = 0.0f;
                int fontSize = SubstanceSizeUtils.getComponentFontSize(mainComp);
                float dashLength = 6.getDashLength(fontSize);
                float dashGap = 6.getDashGap(fontSize);
                FadeTracker fadeTracker = FadeTracker.getInstance();
                if (fadeTracker.isTracked(focusedComp, FadeKind.FOCUS_LOOP_ANIMATION)) {
                    dashPhase = (dashLength + dashGap) * (1.0f - fadeTracker.getFade10(mainComp, FadeKind.FOCUS_LOOP_ANIMATION) / 10.0f);
                }
                graphics.setStroke(new BasicStroke(SubstanceSizeUtils.getFocusStrokeWidth(fontSize), 0, 1, 0.0f, new float[]{dashLength, dashGap}, dashPhase));
                graphics.translate(textRect.x - 1, textRect.y);
                graphics.drawLine(0, textRect.height - 1, textRect.width, textRect.height - 1);
                graphics.dispose();
            }

            public boolean isAnimated() {
                return true;
            }
        }
        ,
        STRONG_UNDERLINE{

            public void paintFocus(Component mainComp, Component focusedComp, Graphics2D graphics, Rectangle focusRect, Rectangle textRect, int extraPadding) {
                if (textRect == null) {
                    return;
                }
                graphics.translate(textRect.x - 1, textRect.y);
                graphics.drawLine(0, textRect.height - 1, textRect.width, textRect.height - 1);
            }
        };


        public abstract void paintFocus(Component var1, Component var2, Graphics2D var3, Rectangle var4, Rectangle var5, int var6);

        public void paintFocus(Component comp, Graphics2D graphics, Rectangle textRect) {
            this.paintFocus(comp, comp, graphics, null, textRect, 0);
        }

        protected static float getDashLength(int fontSize) {
            return 2.0f + (float)SubstanceSizeUtils.getExtraPadding(fontSize);
        }

        protected static float getDashGap(int fontSize) {
            return FocusKind.getDashLength(fontSize) / 2.0f;
        }

        public boolean isAnimated() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TreeIcon {
        CLOSED,
        UP,
        NONE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Side {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

