/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JRootPane;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.painter.text.SubstanceTextPainter;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.title.SubstanceTitlePainter;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceTitleButton;
import org.jvnet.substance.utils.icon.SubstanceIconFactory;
import org.jvnet.substance.utils.icon.TransitionAwareIcon;

public class SubstanceInternalFrameTitlePane
extends BasicInternalFrameTitlePane {
    protected PropertyChangeListener substancePropertyListener;
    protected PropertyChangeListener substanceWinModifiedListener;
    protected static final String ICONIFYING = "substance.internal.internalTitleFramePane.iconifying";
    protected static final String UNINSTALLED = "substance.internal.internalTitleFramePane.uninstalled";

    public SubstanceInternalFrameTitlePane(JInternalFrame f) {
        super(f);
        this.setToolTipText(f.getTitle());
    }

    protected void installListeners() {
        super.installListeners();
        this.substancePropertyListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("title".equals(evt.getPropertyName())) {
                    SubstanceInternalFrameTitlePane.this.setToolTipText((String)evt.getNewValue());
                }
            }
        };
        this.frame.addPropertyChangeListener(this.substancePropertyListener);
        this.substanceWinModifiedListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("windowModified".equals(evt.getPropertyName())) {
                    SubstanceInternalFrameTitlePane.this.syncCloseButtonTooltip();
                }
            }
        };
        this.frame.addPropertyChangeListener(this.substanceWinModifiedListener);
        this.frame.getRootPane().addPropertyChangeListener(this.substanceWinModifiedListener);
    }

    public void uninstallListeners() {
        this.frame.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        this.frame.removePropertyChangeListener(this.substanceWinModifiedListener);
        this.frame.getRootPane().removePropertyChangeListener(this.substanceWinModifiedListener);
        this.substanceWinModifiedListener = null;
        super.uninstallListeners();
    }

    public void uninstall() {
        if (this.menuBar != null && this.menuBar.getMenuCount() > 0) {
            this.menuBar.getUI().uninstallUI(this.menuBar);
            SubstanceCoreUtilities.uninstallMenu(this.menuBar.getMenu(0));
            this.remove(this.menuBar);
        }
        this.uninstallListeners();
        this.putClientProperty(UNINSTALLED, Boolean.TRUE);
    }

    protected void enableActions() {
        super.enableActions();
        if (!this.frame.isIcon()) {
            if (this.maxButton != null) {
                this.maxButton.setEnabled(this.maximizeAction.isEnabled() || this.restoreAction.isEnabled());
            }
            if (this.iconButton != null) {
                this.iconButton.setEnabled(this.iconifyAction.isEnabled());
            }
        }
    }

    public void paintComponent(Graphics g) {
        Icon icon;
        String clippedTitle;
        int titleWidth;
        FontMetrics fm;
        Rectangle rect;
        int rightEnd;
        int leftEnd;
        Icon icon2;
        Graphics2D graphics = (Graphics2D)g.create();
        final float coef = this.getParent() instanceof JInternalFrame.JDesktopIcon ? 0.6f : 1.0f;
        graphics.setComposite(TransitionLayout.getAlphaComposite(this.frame, coef, g));
        boolean isSelected = this.frame.isSelected();
        boolean leftToRight = this.frame.getComponentOrientation().isLeftToRight();
        final int width = this.getWidth();
        final int height = this.getHeight() + 2;
        final SubstanceTheme theme = isSelected ? SubstanceLookAndFeel.getTheme().getActiveTitlePaneTheme() : SubstanceLookAndFeel.getTheme().getDefaultTitlePaneTheme();
        String theTitle = this.frame.getTitle();
        int xOffset = 0;
        if (leftToRight) {
            xOffset = 5;
            icon2 = this.frame.getFrameIcon();
            if (icon2 != null) {
                xOffset += icon2.getIconWidth() + 5;
            }
            leftEnd = this.menuBar == null ? 0 : this.menuBar.getWidth() + 5;
            xOffset += leftEnd;
            if (icon2 != null) {
                leftEnd += icon2.getIconWidth() + 5;
            }
            rightEnd = width - 5;
            JButton leftmostButton = null;
            if (this.frame.isIconifiable()) {
                leftmostButton = this.iconButton;
            } else if (this.frame.isMaximizable()) {
                leftmostButton = this.maxButton;
            } else if (this.frame.isClosable()) {
                leftmostButton = this.closeButton;
            }
            if (leftmostButton != null) {
                rect = leftmostButton.getBounds();
                rightEnd = rect.getBounds().x - 5;
            }
            if (theTitle != null) {
                fm = this.frame.getFontMetrics(graphics.getFont());
                clippedTitle = SubstanceCoreUtilities.clipString(fm, titleWidth = rightEnd - leftEnd, theTitle);
                if (theTitle.equals(clippedTitle)) {
                    this.setToolTipText(null);
                } else {
                    this.setToolTipText(theTitle);
                }
                theTitle = clippedTitle;
            }
        } else {
            xOffset = width - 5;
            icon2 = this.frame.getFrameIcon();
            if (icon2 != null) {
                xOffset -= icon2.getIconWidth() + 5;
            }
            rightEnd = this.menuBar == null ? xOffset : xOffset - this.menuBar.getWidth() - 5;
            JButton rightmostButton = null;
            if (this.frame.isIconifiable()) {
                rightmostButton = this.iconButton;
            } else if (this.frame.isMaximizable()) {
                rightmostButton = this.maxButton;
            } else if (this.frame.isClosable()) {
                rightmostButton = this.closeButton;
            }
            leftEnd = 5;
            if (rightmostButton != null) {
                rect = rightmostButton.getBounds();
                leftEnd = rect.getBounds().x + 5;
            }
            if (theTitle != null) {
                fm = this.frame.getFontMetrics(graphics.getFont());
                clippedTitle = SubstanceCoreUtilities.clipString(fm, titleWidth = rightEnd - leftEnd, theTitle);
                if (theTitle.equals(clippedTitle)) {
                    this.setToolTipText(null);
                } else {
                    this.setToolTipText(theTitle);
                }
                theTitle = clippedTitle;
                xOffset = rightEnd - fm.stringWidth(theTitle);
            }
        }
        SubstanceTextPainter textPainter = SubstanceLookAndFeel.getCurrentTextPainter();
        final SubstanceTitlePainter titlePainter = SubstanceCoreUtilities.getTitlePainter(this.frame);
        if (textPainter.needsBackgroundImage()) {
            final int finalLeftEnd = leftEnd;
            final int finalRightEnd = rightEnd;
            textPainter.setBackgroundImage(this, null, null, false, 0, 0, new SubstanceTextPainter.BackgroundPaintingCallback(){

                public void paintBackground(Graphics g) {
                    Graphics2D graphics = (Graphics2D)g.create();
                    titlePainter.paintTitleBackground(graphics, SubstanceInternalFrameTitlePane.this.frame, width, height + 1, finalLeftEnd, finalRightEnd, theme, 0.0f);
                    if (SubstanceCoreUtilities.toDrawWatermark(SubstanceInternalFrameTitlePane.this)) {
                        SubstanceLookAndFeel.getCurrentWatermark().drawWatermarkImage(graphics, SubstanceInternalFrameTitlePane.this, 0, 0, width, height);
                        Composite oldComp = graphics.getComposite();
                        graphics.setComposite(TransitionLayout.getAlphaComposite(SubstanceInternalFrameTitlePane.this.frame, coef * 0.5f, g));
                        titlePainter.paintTitleBackground(graphics, SubstanceInternalFrameTitlePane.this.frame, width, height + 1, finalLeftEnd, finalRightEnd, theme, 0.0f);
                        graphics.setComposite(oldComp);
                    }
                    graphics.dispose();
                }
            });
        } else {
            titlePainter.paintTitleBackground(graphics, this.frame, width, height + 1, leftEnd, rightEnd, theme, 0.0f);
            if (SubstanceCoreUtilities.toDrawWatermark(this)) {
                if (!Boolean.TRUE.equals(this.getClientProperty("lafwidgets.internal.previewMode"))) {
                    SubstanceLookAndFeel.getCurrentWatermark().drawWatermarkImage(graphics, this, 0, 0, width, height);
                }
                Composite oldComp = graphics.getComposite();
                graphics.setComposite(TransitionLayout.getAlphaComposite(this.frame, coef * 0.5f, g));
                titlePainter.paintTitleBackground(graphics, this.frame, width, height + 1, leftEnd, rightEnd, theme, 0.0f);
                graphics.setComposite(oldComp);
            }
        }
        if (theTitle != null) {
            JRootPane rootPane = this.getRootPane();
            FontMetrics fm2 = rootPane.getFontMetrics(graphics.getFont());
            int yOffset = (height - fm2.getHeight()) / 2 + fm2.getAscent();
            SubstanceCoreUtilities.paintTextWithDropShadow(this, graphics, theme.getForegroundColor(), theTitle, width, height, xOffset, yOffset);
        }
        if ((icon = this.frame.getFrameIcon()) != null) {
            if (leftToRight) {
                int iconY = height / 2 - icon.getIconHeight() / 2;
                icon.paintIcon(this.frame, graphics, 5, iconY);
            } else {
                int iconY = height / 2 - icon.getIconHeight() / 2;
                icon.paintIcon(this.frame, graphics, width - 5 - icon.getIconWidth(), iconY);
            }
        }
        graphics.dispose();
    }

    protected void setButtonIcons() {
        super.setButtonIcons();
        TransitionAwareIcon restoreIcon = new TransitionAwareIcon(this.maxButton, new TransitionAwareIcon.Delegate(){

            public Icon getThemeIcon(SubstanceTheme theme) {
                return SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.RESTORE, theme);
            }
        });
        TransitionAwareIcon maximizeIcon = new TransitionAwareIcon(this.maxButton, new TransitionAwareIcon.Delegate(){

            public Icon getThemeIcon(SubstanceTheme theme) {
                return SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.MAXIMIZE, theme);
            }
        });
        TransitionAwareIcon minimizeIcon = new TransitionAwareIcon(this.iconButton, new TransitionAwareIcon.Delegate(){

            public Icon getThemeIcon(SubstanceTheme theme) {
                return SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.MINIMIZE, theme);
            }
        });
        TransitionAwareIcon closeIcon = new TransitionAwareIcon(this.closeButton, new TransitionAwareIcon.Delegate(){

            public Icon getThemeIcon(SubstanceTheme theme) {
                return SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.CLOSE, theme);
            }
        });
        if (this.frame.isIcon()) {
            this.iconButton.setIcon(restoreIcon);
            this.iconButton.setToolTipText(SubstanceCoreUtilities.getResourceBundle(this.frame).getString("SystemMenu.restore"));
            this.maxButton.setIcon(maximizeIcon);
            this.maxButton.setToolTipText(SubstanceCoreUtilities.getResourceBundle(this.frame).getString("SystemMenu.maximize"));
        } else {
            this.iconButton.setIcon(minimizeIcon);
            this.iconButton.setToolTipText(SubstanceCoreUtilities.getResourceBundle(this.frame).getString("SystemMenu.iconify"));
            if (this.frame.isMaximum()) {
                this.maxButton.setIcon(restoreIcon);
                this.maxButton.setToolTipText(SubstanceCoreUtilities.getResourceBundle(this.frame).getString("SystemMenu.restore"));
            } else {
                this.maxButton.setIcon(maximizeIcon);
                this.maxButton.setToolTipText(SubstanceCoreUtilities.getResourceBundle(this.frame).getString("SystemMenu.maximize"));
            }
        }
        if (closeIcon != null) {
            this.closeButton.setIcon(closeIcon);
            this.syncCloseButtonTooltip();
        }
    }

    protected void createActions() {
        super.createActions();
        this.iconifyAction = new SubstanceIconifyAction();
    }

    protected void createButtons() {
        this.iconButton = new SubstanceTitleButton("InternalFrameTitlePane.iconifyButtonAccessibleName");
        this.iconButton.addActionListener(this.iconifyAction);
        this.maxButton = new SubstanceTitleButton("InternalFrameTitlePane.maximizeButtonAccessibleName");
        this.maxButton.addActionListener(this.maximizeAction);
        this.closeButton = new SubstanceTitleButton("InternalFrameTitlePane.closeButtonAccessibleName");
        this.closeButton.addActionListener(this.closeAction);
        this.setButtonIcons();
        for (ActionListener listener : this.iconButton.getActionListeners()) {
            if (!(listener instanceof ClickListener)) continue;
            return;
        }
        this.iconButton.addActionListener(new ClickListener());
        for (ActionListener listener : this.maxButton.getActionListeners()) {
            if (!(listener instanceof ClickListener)) continue;
            return;
        }
        this.maxButton.addActionListener(new ClickListener());
        this.iconButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        this.maxButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        this.closeButton.putClientProperty("substancelaf.internal.isTitleCloseButton", Boolean.TRUE);
        this.closeButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        this.enableActions();
    }

    protected LayoutManager createLayout() {
        return new SubstanceTitlePaneLayout();
    }

    protected void syncCloseButtonTooltip() {
        if (SubstanceCoreUtilities.isInternalFrameModified(this.frame)) {
            this.closeButton.setToolTipText(SubstanceCoreUtilities.getResourceBundle(this.frame).getString("SystemMenu.close") + " [" + SubstanceCoreUtilities.getResourceBundle(this.frame).getString("Tooltip.contentsNotSaved") + "]");
        } else {
            this.closeButton.setToolTipText(SubstanceCoreUtilities.getResourceBundle(this.frame).getString("SystemMenu.close"));
        }
        this.closeButton.repaint();
    }

    public void removeNotify() {
        boolean isAlive;
        super.removeNotify();
        boolean bl = isAlive = this.frame.isIcon() && !this.frame.isClosed() || Boolean.TRUE.equals(this.frame.getClientProperty(ICONIFYING));
        if (!isAlive) {
            this.uninstall();
        }
    }

    public void addNotify() {
        super.addNotify();
        if (Boolean.TRUE.equals(this.getClientProperty(UNINSTALLED))) {
            this.installTitlePane();
            this.putClientProperty(UNINSTALLED, null);
        }
    }

    public class SubstanceIconifyAction
    extends BasicInternalFrameTitlePane.IconifyAction {
        public SubstanceIconifyAction() {
            super(SubstanceInternalFrameTitlePane.this);
        }

        public void actionPerformed(ActionEvent e) {
            SubstanceInternalFrameTitlePane.this.frame.putClientProperty(SubstanceInternalFrameTitlePane.ICONIFYING, Boolean.TRUE);
            super.actionPerformed(e);
            SubstanceInternalFrameTitlePane.this.frame.putClientProperty(SubstanceInternalFrameTitlePane.ICONIFYING, null);
        }
    }

    protected class SubstanceTitlePaneLayout
    extends BasicInternalFrameTitlePane.TitlePaneLayout {
        protected SubstanceTitlePaneLayout() {
            super(SubstanceInternalFrameTitlePane.this);
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        public Dimension minimumLayoutSize(Container c) {
            int subtitle_w;
            int title_length;
            int width = 30;
            if (SubstanceInternalFrameTitlePane.this.frame.isClosable()) {
                width += 21;
            }
            if (SubstanceInternalFrameTitlePane.this.frame.isMaximizable()) {
                width += 16 + (SubstanceInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4);
            }
            if (SubstanceInternalFrameTitlePane.this.frame.isIconifiable()) {
                width += 16 + (SubstanceInternalFrameTitlePane.this.frame.isMaximizable() ? 2 : (SubstanceInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4));
            }
            FontMetrics fm = SubstanceInternalFrameTitlePane.this.frame.getFontMetrics(SubstanceInternalFrameTitlePane.this.getFont());
            String frameTitle = SubstanceInternalFrameTitlePane.this.frame.getTitle();
            int title_w = frameTitle != null ? fm.stringWidth(frameTitle) : 0;
            int n = title_length = frameTitle != null ? frameTitle.length() : 0;
            width = title_length > 2 ? (width += title_w < (subtitle_w = fm.stringWidth(SubstanceInternalFrameTitlePane.this.frame.getTitle().substring(0, 2) + "...")) ? title_w : subtitle_w) : (width += title_w);
            int height = 0;
            int fontHeight = fm.getHeight();
            fontHeight += 7;
            Icon icon = SubstanceInternalFrameTitlePane.this.frame.getFrameIcon();
            int iconHeight = 0;
            if (icon != null) {
                iconHeight = Math.min(icon.getIconHeight(), 16);
            }
            height = Math.max(fontHeight, iconHeight += 5);
            return new Dimension(width, height);
        }

        public void layoutContainer(Container c) {
            int spacing;
            boolean leftToRight = SubstanceInternalFrameTitlePane.this.frame.getComponentOrientation().isLeftToRight();
            int w = SubstanceInternalFrameTitlePane.this.getWidth();
            int x = leftToRight ? w : 0;
            int y = 2;
            int buttonHeight = SubstanceInternalFrameTitlePane.this.closeButton.getIcon().getIconHeight();
            int buttonWidth = SubstanceInternalFrameTitlePane.this.closeButton.getIcon().getIconWidth();
            y = (SubstanceInternalFrameTitlePane.this.getHeight() - buttonHeight) / 2;
            if (SubstanceInternalFrameTitlePane.this.frame.isClosable()) {
                spacing = 4;
                SubstanceInternalFrameTitlePane.this.closeButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
            if (SubstanceInternalFrameTitlePane.this.frame.isMaximizable()) {
                spacing = SubstanceInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4;
                SubstanceInternalFrameTitlePane.this.maxButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
            if (SubstanceInternalFrameTitlePane.this.frame.isIconifiable()) {
                spacing = SubstanceInternalFrameTitlePane.this.frame.isMaximizable() ? 2 : (SubstanceInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4);
                SubstanceInternalFrameTitlePane.this.iconButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
        }
    }

    public static class ClickListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            AbstractButton src = (AbstractButton)e.getSource();
            ButtonModel model = src.getModel();
            model.setArmed(false);
            model.setPressed(false);
            model.setRollover(false);
            model.setSelected(false);
        }
    }
}

