/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.animation.effects.GhostPaintingUtils;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.LafConstants;
import org.jvnet.lafwidget.utils.TrackableThread;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceRootPaneUI;
import org.jvnet.substance.border.BorderPainterChangeListener;
import org.jvnet.substance.border.BorderPainterInfo;
import org.jvnet.substance.button.ButtonShaperChangeListener;
import org.jvnet.substance.button.ButtonShaperInfo;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.painter.GradientPainterChangeListener;
import org.jvnet.substance.painter.GradientPainterInfo;
import org.jvnet.substance.painter.text.SubstanceTextPainter;
import org.jvnet.substance.skin.SkinInfo;
import org.jvnet.substance.theme.MixedThemeInfo;
import org.jvnet.substance.theme.SubstanceColorBlindTheme;
import org.jvnet.substance.theme.SubstanceInvertedTheme;
import org.jvnet.substance.theme.SubstanceMixTheme;
import org.jvnet.substance.theme.SubstanceNegatedTheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.theme.ThemeChangeListener;
import org.jvnet.substance.theme.ThemeInfo;
import org.jvnet.substance.title.SubstanceTitlePainter;
import org.jvnet.substance.title.TitlePainterChangeListener;
import org.jvnet.substance.title.TitlePainterInfo;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.SubstanceTitleButton;
import org.jvnet.substance.utils.icon.SubstanceIconFactory;
import org.jvnet.substance.utils.icon.TransitionAwareIcon;
import org.jvnet.substance.utils.menu.TraitMenuHandler;
import org.jvnet.substance.watermark.SubstanceWatermark;
import org.jvnet.substance.watermark.WatermarkChangeListener;
import org.jvnet.substance.watermark.WatermarkInfo;

public class SubstanceTitlePane
extends JComponent {
    public static final String HEAP_STATUS_PANEL_PERMANENT = "substancelaf.internal.heapStatusPanelPermanent";
    private PropertyChangeListener propertyChangeListener;
    private JMenuBar menuBar;
    private Action closeAction;
    private Action iconifyAction;
    private Action restoreAction;
    private Action maximizeAction;
    private JButton toggleButton;
    private JButton minimizeButton;
    private JButton closeButton;
    private WindowListener windowListener;
    private Window window;
    private JRootPane rootPane;
    private int state;
    private SubstanceRootPaneUI rootPaneUI;
    protected static boolean canHaveHeapStatusPanel;
    protected static String heapStatusLogfileName;
    protected HeapStatusPanel heapStatusPanel;
    protected JCheckBoxMenuItem heapStatusMenuItem;
    protected PropertyChangeListener propertyListener;
    protected TraitMenuHandler themeMenuHandler;
    protected ThemeChangeListener themeChangeListener;
    protected TraitMenuHandler watermarkMenuHandler;
    protected WatermarkChangeListener watermarkChangeListener;
    protected TraitMenuHandler buttonShaperMenuHandler;
    protected ButtonShaperChangeListener buttonShaperChangeListener;
    protected TraitMenuHandler gradientPainterMenuHandler;
    protected GradientPainterChangeListener gradientPainterChangeListener;
    protected TraitMenuHandler titlePainterMenuHandler;
    protected TitlePainterChangeListener titlePainterChangeListener;
    protected TraitMenuHandler borderPainterMenuHandler;
    protected BorderPainterChangeListener borderPainterChangeListener;
    protected MouseListener substanceDebugUiListener;
    public static final String HAS_BEEN_UNINSTALLED = "substancelaf.internal.titlePane.hasBeenUninstalled";

    public SubstanceTitlePane(JRootPane root, SubstanceRootPaneUI ui) {
        this.rootPane = root;
        this.rootPaneUI = ui;
        this.state = -1;
        this.installSubcomponents();
        this.installDefaults();
        this.setLayout(this.createLayout());
        this.setToolTipText(this.getTitle());
    }

    public void uninstall() {
        this.uninstallListeners();
        this.window = null;
        if (this.menuBar != null && this.menuBar.getMenuCount() > 0) {
            this.menuBar.getUI().uninstallUI(this.menuBar);
            SubstanceCoreUtilities.uninstallMenu(this.menuBar.getMenu(0));
        }
        if (canHaveHeapStatusPanel && this.heapStatusPanel != null) {
            for (MouseListener listener : this.heapStatusPanel.getMouseListeners()) {
                this.heapStatusPanel.removeMouseListener(listener);
            }
            HeapStatusThread.unregisterPanel(this.heapStatusPanel);
            this.remove(this.heapStatusPanel);
        }
        if (this.menuBar != null) {
            this.menuBar.removeAll();
        }
        this.removeAll();
        SubstanceLookAndFeel.unregisterThemeChangeListener(this.themeChangeListener);
        this.themeChangeListener = null;
        SubstanceLookAndFeel.unregisterWatermarkChangeListener(this.watermarkChangeListener);
        this.watermarkChangeListener = null;
        SubstanceLookAndFeel.unregisterButtonShaperChangeListener(this.buttonShaperChangeListener);
        this.buttonShaperChangeListener = null;
        SubstanceLookAndFeel.unregisterGradientPainterChangeListener(this.gradientPainterChangeListener);
        this.gradientPainterChangeListener = null;
        SubstanceLookAndFeel.unregisterTitlePainterChangeListener(this.titlePainterChangeListener);
        this.titlePainterChangeListener = null;
        SubstanceLookAndFeel.unregisterBorderPainterChangeListener(this.borderPainterChangeListener);
        this.borderPainterChangeListener = null;
    }

    private void installListeners() {
        if (this.window != null) {
            this.windowListener = new WindowHandler();
            this.window.addWindowListener(this.windowListener);
            this.propertyChangeListener = new PropertyChangeHandler();
            this.window.addPropertyChangeListener(this.propertyChangeListener);
        }
        this.propertyListener = new PropertyChangeListener(){

            public void propertyChange(final PropertyChangeEvent evt) {
                if ("windowModified".equals(evt.getPropertyName())) {
                    SubstanceTitlePane.this.syncCloseButtonTooltip();
                }
                if ("componentOrientation".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (SubstanceTitlePane.this.menuBar != null) {
                                SubstanceTitlePane.this.menuBar.applyComponentOrientation((ComponentOrientation)evt.getNewValue());
                            }
                        }
                    });
                }
            }
        };
        this.rootPane.addPropertyChangeListener(this.propertyListener);
        if (this.getFrame() != null) {
            this.getFrame().addPropertyChangeListener(this.propertyListener);
        }
        if (SubstanceLookAndFeel.isDebugUiMode()) {
            this.substanceDebugUiListener = new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    this.process(e);
                }

                public void mouseReleased(MouseEvent e) {
                    this.process(e);
                }

                protected void process(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        JPopupMenu popup = new JPopupMenu();
                        JMenu cbMenu = new JMenu("Color blindness");
                        JMenuItem protanopiaCurrent = new JMenuItem("Protanopia current");
                        protanopiaCurrent.addActionListener(new ThemeChanger(SubstanceLookAndFeel.getTheme().protanopia()));
                        cbMenu.add(protanopiaCurrent);
                        JMenuItem deuteranopiaCurrent = new JMenuItem("Deuteranopia current");
                        deuteranopiaCurrent.addActionListener(new ThemeChanger(SubstanceLookAndFeel.getTheme().deuteranopia()));
                        cbMenu.add(deuteranopiaCurrent);
                        JMenuItem tritanopiaCurrent = new JMenuItem("Tritanopia current");
                        tritanopiaCurrent.addActionListener(new ThemeChanger(SubstanceLookAndFeel.getTheme().tritanopia()));
                        cbMenu.add(tritanopiaCurrent);
                        cbMenu.addSeparator();
                        JMenuItem restoreOriginal = new JMenuItem("Restore original");
                        if (SubstanceLookAndFeel.getTheme() instanceof SubstanceColorBlindTheme) {
                            restoreOriginal.addActionListener(new ThemeChanger(((SubstanceColorBlindTheme)SubstanceLookAndFeel.getTheme()).getOriginalTheme()));
                        } else {
                            restoreOriginal.setEnabled(false);
                        }
                        cbMenu.add(restoreOriginal);
                        popup.add(cbMenu);
                        JMenu animMenu = new JMenu("Animation rate");
                        JMenuItem debugNone = new JMenuItem("None");
                        debugNone.addActionListener(new AnimationChanger(LafConstants.AnimationKind.NONE));
                        animMenu.add(debugNone);
                        JMenuItem debugAnim = new JMenuItem("Debug rate (extra slow)");
                        debugAnim.addActionListener(new AnimationChanger(LafConstants.AnimationKind.DEBUG));
                        animMenu.add(debugAnim);
                        JMenuItem debugAnimFast = new JMenuItem("Debug rate (faster)");
                        debugAnimFast.addActionListener(new AnimationChanger(LafConstants.AnimationKind.DEBUG_FAST));
                        animMenu.add(debugAnimFast);
                        JMenuItem debugSlow = new JMenuItem("Slow rate");
                        debugSlow.addActionListener(new AnimationChanger(LafConstants.AnimationKind.SLOW));
                        animMenu.add(debugSlow);
                        JMenuItem debugRegular = new JMenuItem("Regular rate");
                        debugRegular.addActionListener(new AnimationChanger(LafConstants.AnimationKind.REGULAR));
                        animMenu.add(debugRegular);
                        JMenuItem debugFast = new JMenuItem("Fast rate");
                        debugFast.addActionListener(new AnimationChanger(LafConstants.AnimationKind.FAST));
                        animMenu.add(debugFast);
                        popup.add(animMenu);
                        JMenu focusMenu = new JMenu("Focus kind");
                        for (SubstanceConstants.FocusKind fKind : SubstanceConstants.FocusKind.values()) {
                            JMenuItem focusMenuItem = new JMenuItem(fKind.name().toLowerCase());
                            focusMenuItem.addActionListener(new FocusKindChanger(fKind));
                            focusMenu.add(focusMenuItem);
                        }
                        popup.add(focusMenu);
                        JMenuItem dumpHierarchy = new JMenuItem("Dump hierarchy");
                        dumpHierarchy.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                SubstanceTitlePane.dump(SubstanceTitlePane.this.rootPane, 0);
                            }
                        });
                        popup.add(dumpHierarchy);
                        final JCheckBoxMenuItem ltrChange = new JCheckBoxMenuItem("Is left-to-right");
                        ltrChange.setSelected(SubstanceTitlePane.this.rootPane.getComponentOrientation().isLeftToRight());
                        ltrChange.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        SubstanceTitlePane.this.rootPane.applyComponentOrientation(ltrChange.isSelected() ? ComponentOrientation.LEFT_TO_RIGHT : ComponentOrientation.RIGHT_TO_LEFT);
                                    }
                                });
                            }
                        });
                        popup.add(ltrChange);
                        final JCheckBoxMenuItem useThemedIcons = new JCheckBoxMenuItem("Use themed icons");
                        useThemedIcons.setSelected(SubstanceCoreUtilities.useThemedDefaultIcon(null));
                        useThemedIcons.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        UIManager.put("substancelaf.useThemedDefaultIcons", useThemedIcons.isSelected() ? Boolean.TRUE : null);
                                        SubstanceTitlePane.this.rootPane.repaint();
                                    }
                                });
                            }
                        });
                        popup.add(useThemedIcons);
                        final JCheckBoxMenuItem ghostDebugMode = new JCheckBoxMenuItem("Ghost debug mode");
                        ghostDebugMode.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        ghostDebugMode.setEnabled(false);
                                        GhostPaintingUtils.MAX_ICON_GHOSTING_ALPHA = 0.8f;
                                        GhostPaintingUtils.MIN_ICON_GHOSTING_ALPHA = 0.6f;
                                        GhostPaintingUtils.MAX_PRESS_GHOSTING_ALPHA = 0.8f;
                                        GhostPaintingUtils.MIN_PRESS_GHOSTING_ALPHA = 0.6f;
                                        GhostPaintingUtils.DECAY_FACTOR = 0.7f;
                                    }
                                });
                            }
                        });
                        popup.add(ghostDebugMode);
                        popup.show(SubstanceTitlePane.this, e.getX(), e.getY());
                    }
                }
            };
            this.addMouseListener(this.substanceDebugUiListener);
        }
    }

    private void uninstallListeners() {
        if (this.window != null) {
            this.window.removeWindowListener(this.windowListener);
            this.windowListener = null;
            this.window.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        this.rootPane.removePropertyChangeListener(this.propertyListener);
        if (this.getFrame() != null) {
            this.getFrame().removePropertyChangeListener(this.propertyListener);
        }
        this.propertyListener = null;
        if (this.substanceDebugUiListener != null) {
            this.removeMouseListener(this.substanceDebugUiListener);
            this.substanceDebugUiListener = null;
        }
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    private int getWindowDecorationStyle() {
        return this.getRootPane().getWindowDecorationStyle();
    }

    public void addNotify() {
        super.addNotify();
        this.uninstallListeners();
        this.window = SwingUtilities.getWindowAncestor(this);
        if (this.window != null) {
            this.setActive(this.window.isActive());
            if (Boolean.TRUE.equals(SwingUtilities.getRootPane(this).getClientProperty(HAS_BEEN_UNINSTALLED))) {
                this.installSubcomponents();
                this.installDefaults();
                this.setLayout(this.createLayout());
                this.setToolTipText(this.getTitle());
            }
            if (this.window instanceof Frame) {
                this.setState(((Frame)this.window).getExtendedState());
            } else {
                this.setState(0);
            }
            this.installListeners();
        }
        this.setToolTipText(this.getTitle());
    }

    public void removeNotify() {
        SwingUtilities.getRootPane(this).putClientProperty(HAS_BEEN_UNINSTALLED, Boolean.TRUE);
        super.removeNotify();
        this.uninstall();
        this.window = null;
    }

    private void installSubcomponents() {
        int decorationStyle = this.getWindowDecorationStyle();
        if (decorationStyle == 1) {
            this.createActions();
            this.menuBar = this.createMenuBar();
            this.add(this.menuBar);
            this.createButtons();
            this.add(this.minimizeButton);
            this.add(this.toggleButton);
            this.add(this.closeButton);
            if (canHaveHeapStatusPanel) {
                this.heapStatusPanel = new HeapStatusPanel();
                this.add(this.heapStatusPanel);
                boolean isHeapStatusPanelShowing = Boolean.TRUE.equals(this.rootPane.getClientProperty("substancelaf.heapStatusPanel"));
                this.heapStatusPanel.setVisible(isHeapStatusPanelShowing);
                this.heapStatusPanel.setPreferredSize(new Dimension(80, this.getPreferredSize().height));
                this.heapStatusPanel.setToolTipText(SubstanceCoreUtilities.getResourceBundle(this.rootPane).getString("Tooltip.heapStatusPanel"));
                this.heapStatusPanel.addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent e) {
                        System.gc();
                    }
                });
                HeapStatusThread.registerPanel(this.heapStatusPanel);
            }
        } else if (decorationStyle == 2 || decorationStyle == 3 || decorationStyle == 4 || decorationStyle == 5 || decorationStyle == 6 || decorationStyle == 7 || decorationStyle == 8) {
            this.createActions();
            this.createButtons();
            this.add(this.closeButton);
        }
    }

    private void installDefaults() {
        this.setFont(UIManager.getFont("InternalFrame.titleFont", this.getLocale()));
    }

    protected JMenuBar createMenuBar() {
        this.menuBar = new SubstanceMenuBar();
        this.menuBar.setFocusable(false);
        this.menuBar.setBorderPainted(true);
        this.menuBar.add(this.createMenu());
        this.menuBar.setOpaque(false);
        this.menuBar.applyComponentOrientation(this.rootPane.getComponentOrientation());
        return this.menuBar;
    }

    private void createActions() {
        this.closeAction = new CloseAction();
        if (this.getWindowDecorationStyle() == 1) {
            this.iconifyAction = new IconifyAction();
            this.restoreAction = new RestoreAction();
            this.maximizeAction = new MaximizeAction();
        }
    }

    private JMenu createMenu() {
        JMenu menu = new JMenu("");
        menu.setOpaque(false);
        menu.setBackground(null);
        if (this.getWindowDecorationStyle() == 1) {
            this.addMenuItems(menu);
        }
        return menu;
    }

    private void addMenuItems(JMenu menu) {
        menu.add(this.restoreAction);
        menu.add(this.iconifyAction);
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            menu.add(this.maximizeAction);
        }
        if (SubstanceLookAndFeel.toShowExtraElements()) {
            menu.addSeparator();
            JMenu skinMenu = new JMenu(SubstanceCoreUtilities.getResourceBundle(this.rootPane).getString("SystemMenu.skins"));
            Map<String, SkinInfo> allSkins = SubstanceLookAndFeel.getAllSkins();
            for (Map.Entry<String, SkinInfo> skinEntry : allSkins.entrySet()) {
                final String skinClassName = skinEntry.getValue().getClassName();
                JMenuItem jmiSkin = new JMenuItem(skinEntry.getKey());
                jmiSkin.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                SubstanceLookAndFeel.setSkin(skinClassName);
                            }
                        });
                    }
                });
                skinMenu.add(jmiSkin);
            }
            menu.add(skinMenu);
            JMenu themeMenu = new JMenu(SubstanceCoreUtilities.getResourceBundle(this.rootPane).getString("SystemMenu.themes"));
            ButtonGroup bgTheme = new ButtonGroup();
            JMenu brightThemes = new JMenu(SubstanceCoreUtilities.getResourceBundle(this.rootPane).getString("SystemMenu.themesBright"));
            JMenu coldThemes = new JMenu(SubstanceCoreUtilities.getResourceBundle(this.rootPane).getString("SystemMenu.themesCold"));
            JMenu darkThemes = new JMenu(SubstanceCoreUtilities.getResourceBundle(this.rootPane).getString("SystemMenu.themesDark"));
            JMenu invertedThemes = SubstanceLookAndFeel.toEnableInvertedThemes() ? new JMenu(SubstanceCoreUtilities.getResourceBundle(this.rootPane).getString("SystemMenu.themesInverted")) : null;
            JMenu negatedThemes = SubstanceLookAndFeel.toEnableNegatedThemes() ? new JMenu(SubstanceCoreUtilities.getResourceBundle(this.rootPane).getString("SystemMenu.themesNegated")) : null;
            JMenu mixedThemes = SubstanceLookAndFeel.hasMixedThemes() ? new JMenu(SubstanceCoreUtilities.getResourceBundle(this.rootPane).getString("SystemMenu.themesMixed")) : null;
            themeMenu.add(brightThemes);
            themeMenu.add(coldThemes);
            themeMenu.add(darkThemes);
            if (invertedThemes != null) {
                themeMenu.add(invertedThemes);
            }
            if (negatedThemes != null) {
                themeMenu.add(negatedThemes);
            }
            if (mixedThemes != null) {
                themeMenu.add(mixedThemes);
            }
            this.themeMenuHandler = new TraitMenuHandler();
            Map<String, ThemeInfo> allThemes = SubstanceLookAndFeel.getAllThemes();
            for (Map.Entry<String, ThemeInfo> themeEntry : allThemes.entrySet()) {
                final ThemeInfo themeInfo = themeEntry.getValue();
                String themeClassName = themeInfo.getClassName();
                JRadioButtonMenuItem jmiTheme = new JRadioButtonMenuItem(themeEntry.getKey());
                this.themeMenuHandler.addTraitButton(themeInfo.getDisplayName(), jmiTheme);
                jmiTheme.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                SubstanceLookAndFeel.setCurrentTheme(themeInfo);
                                for (Frame frame : Frame.getFrames()) {
                                    SwingUtilities.updateComponentTreeUI(frame);
                                }
                            }
                        });
                    }
                });
                try {
                    switch (themeInfo.getThemeKind()) {
                        case MIXED: {
                            Class<?> themeClass;
                            MixedThemeInfo mixedThemeInfo = (MixedThemeInfo)themeInfo;
                            String[] themeClassNames = mixedThemeInfo.getThemeClassNames();
                            SubstanceTheme[] themeInstances = new SubstanceTheme[themeClassNames.length];
                            for (int i = 0; i < themeClassNames.length; ++i) {
                                themeClass = Class.forName(themeClassNames[i]);
                                themeInstances[i] = (SubstanceTheme)themeClass.newInstance();
                            }
                            SubstanceMixTheme mixTheme = new SubstanceMixTheme(themeInstances);
                            jmiTheme.setIcon(SubstanceImageCreator.getThemeIcon(mixTheme));
                            break;
                        }
                        default: {
                            Class<?> themeClass = Class.forName(themeClassName);
                            SubstanceTheme theme = (SubstanceTheme)themeClass.newInstance();
                            if (themeInfo.getThemeKind() == SubstanceTheme.ThemeKind.INVERTED) {
                                theme = new SubstanceInvertedTheme(theme);
                            }
                            if (themeInfo.getThemeKind() == SubstanceTheme.ThemeKind.NEGATED) {
                                theme = new SubstanceNegatedTheme(theme);
                            }
                            jmiTheme.setIcon(SubstanceImageCreator.getThemeIcon(theme));
                            break;
                        }
                    }
                }
                catch (Exception exc) {
                    continue;
                }
                if (themeEntry.getKey().equals(SubstanceLookAndFeel.getCurrentThemeName())) {
                    jmiTheme.setSelected(true);
                }
                switch (themeEntry.getValue().getThemeKind()) {
                    case BRIGHT: {
                        brightThemes.add(jmiTheme);
                        break;
                    }
                    case COLD: {
                        coldThemes.add(jmiTheme);
                        break;
                    }
                    case DARK: {
                        darkThemes.add(jmiTheme);
                        break;
                    }
                    case INVERTED: {
                        invertedThemes.add(jmiTheme);
                        break;
                    }
                    case NEGATED: {
                        negatedThemes.add(jmiTheme);
                        break;
                    }
                    case MIXED: {
                        mixedThemes.add(jmiTheme);
                    }
                }
                bgTheme.add(jmiTheme);
            }
            themeMenu.setIcon(SubstanceImageCreator.getThemeIcon(null));
            menu.add(themeMenu);
            this.themeChangeListener = new ThemeChangeListener(){

                public void themeChanged() {
                    SubstanceTitlePane.this.themeMenuHandler.selectTraitButton(SubstanceLookAndFeel.getTheme());
                }
            };
            SubstanceLookAndFeel.registerThemeChangeListener(this.themeChangeListener);
            JMenu watermarkMenu = new JMenu(SubstanceCoreUtilities.getResourceBundle(this.rootPane).getString("SystemMenu.watermarks"));
            ButtonGroup bgWatermark = new ButtonGroup();
            this.watermarkMenuHandler = new TraitMenuHandler();
            Map<String, WatermarkInfo> allWatermarks = SubstanceLookAndFeel.getAllWatermarks();
            for (Map.Entry<String, WatermarkInfo> watermarkEntry : allWatermarks.entrySet()) {
                final String watermarkClassName = watermarkEntry.getValue().getClassName();
                JRadioButtonMenuItem jmiWatermark = new JRadioButtonMenuItem(watermarkEntry.getKey());
                this.watermarkMenuHandler.addTraitButton(watermarkEntry.getValue().getDisplayName(), jmiWatermark);
                jmiWatermark.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                SubstanceLookAndFeel.setCurrentWatermark(watermarkClassName);
                                for (Frame frame : Frame.getFrames()) {
                                    SwingUtilities.updateComponentTreeUI(frame);
                                }
                            }
                        });
                    }
                });
                if (watermarkEntry.getKey().equals(SubstanceLookAndFeel.getCurrentWatermarkName())) {
                    jmiWatermark.setSelected(true);
                }
                try {
                    Class<?> watermarkClass = Class.forName(watermarkClassName);
                    SubstanceWatermark watermark = (SubstanceWatermark)watermarkClass.newInstance();
                    jmiWatermark.setIcon(SubstanceImageCreator.getWatermarkIcon(watermark));
                }
                catch (Exception exc) {
                    // empty catch block
                }
                bgWatermark.add(jmiWatermark);
                watermarkMenu.add(jmiWatermark);
            }
            menu.add(watermarkMenu);
            this.watermarkChangeListener = new WatermarkChangeListener(){

                public void watermarkChanged() {
                    SubstanceTitlePane.this.watermarkMenuHandler.selectTraitButton(SubstanceLookAndFeel.getCurrentWatermark());
                }
            };
            SubstanceLookAndFeel.registerWatermarkChangeListener(this.watermarkChangeListener);
            JMenu buttonShaperMenu = new JMenu(SubstanceCoreUtilities.getResourceBundle(this.rootPane).getString("SystemMenu.buttonShapers"));
            ButtonGroup bgButtonShaper = new ButtonGroup();
            this.buttonShaperMenuHandler = new TraitMenuHandler();
            Map<String, ButtonShaperInfo> allButtonShapers = SubstanceLookAndFeel.getAllButtonShapers();
            for (Map.Entry<String, ButtonShaperInfo> buttonShaperEntry : allButtonShapers.entrySet()) {
                final String buttonShaperClassName = buttonShaperEntry.getValue().getClassName();
                JRadioButtonMenuItem jmiButtonShaper = new JRadioButtonMenuItem(buttonShaperEntry.getKey());
                this.buttonShaperMenuHandler.addTraitButton(buttonShaperEntry.getValue().getDisplayName(), jmiButtonShaper);
                jmiButtonShaper.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                SubstanceLookAndFeel.setCurrentButtonShaper(buttonShaperClassName);
                                for (Frame frame : Frame.getFrames()) {
                                    SwingUtilities.updateComponentTreeUI(frame);
                                }
                            }
                        });
                    }
                });
                if (buttonShaperEntry.getKey().equals(SubstanceLookAndFeel.getCurrentButtonShaperName())) {
                    jmiButtonShaper.setSelected(true);
                }
                bgButtonShaper.add(jmiButtonShaper);
                buttonShaperMenu.add(jmiButtonShaper);
            }
            menu.add(buttonShaperMenu);
            this.buttonShaperChangeListener = new ButtonShaperChangeListener(){

                public void buttonShaperChanged() {
                    SubstanceTitlePane.this.buttonShaperMenuHandler.selectTraitButton(SubstanceLookAndFeel.getCurrentButtonShaper());
                }
            };
            SubstanceLookAndFeel.registerButtonShaperChangeListener(this.buttonShaperChangeListener);
            JMenu borderPainterMenu = new JMenu(SubstanceCoreUtilities.getResourceBundle(this.rootPane).getString("SystemMenu.borderPainters"));
            ButtonGroup bgBorderPainter = new ButtonGroup();
            this.borderPainterMenuHandler = new TraitMenuHandler();
            Map<String, BorderPainterInfo> allBorderPainters = SubstanceLookAndFeel.getAllBorderPainters();
            for (Map.Entry<String, BorderPainterInfo> borderPainterEntry : allBorderPainters.entrySet()) {
                final String borderPainterClassName = borderPainterEntry.getValue().getClassName();
                JRadioButtonMenuItem jmiBorderPainter = new JRadioButtonMenuItem(borderPainterEntry.getKey());
                this.borderPainterMenuHandler.addTraitButton(borderPainterEntry.getValue().getDisplayName(), jmiBorderPainter);
                jmiBorderPainter.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                SubstanceLookAndFeel.setCurrentBorderPainter(borderPainterClassName);
                                for (Frame frame : Frame.getFrames()) {
                                    SwingUtilities.updateComponentTreeUI(frame);
                                }
                            }
                        });
                    }
                });
                if (borderPainterEntry.getKey().equals(SubstanceLookAndFeel.getCurrentBorderPainterName())) {
                    jmiBorderPainter.setSelected(true);
                }
                bgBorderPainter.add(jmiBorderPainter);
                borderPainterMenu.add(jmiBorderPainter);
            }
            menu.add(borderPainterMenu);
            this.borderPainterChangeListener = new BorderPainterChangeListener(){

                public void borderPainterChanged() {
                    SubstanceTitlePane.this.borderPainterMenuHandler.selectTraitButton(SubstanceLookAndFeel.getCurrentBorderPainter());
                }
            };
            SubstanceLookAndFeel.registerBorderPainterChangeListener(this.borderPainterChangeListener);
            JMenu gradientPainterMenu = new JMenu(SubstanceCoreUtilities.getResourceBundle(this.rootPane).getString("SystemMenu.gradientPainters"));
            ButtonGroup bgGradientPainter = new ButtonGroup();
            this.gradientPainterMenuHandler = new TraitMenuHandler();
            Map<String, GradientPainterInfo> allGradientPainters = SubstanceLookAndFeel.getAllGradientPainters();
            for (Map.Entry<String, GradientPainterInfo> gradientPainterEntry : allGradientPainters.entrySet()) {
                final String gradientPainterClassName = gradientPainterEntry.getValue().getClassName();
                JRadioButtonMenuItem jmiGradientPainter = new JRadioButtonMenuItem(gradientPainterEntry.getKey());
                this.gradientPainterMenuHandler.addTraitButton(gradientPainterEntry.getValue().getDisplayName(), jmiGradientPainter);
                jmiGradientPainter.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                SubstanceLookAndFeel.setCurrentGradientPainter(gradientPainterClassName);
                                for (Frame frame : Frame.getFrames()) {
                                    SwingUtilities.updateComponentTreeUI(frame);
                                }
                            }
                        });
                    }
                });
                if (gradientPainterEntry.getKey().equals(SubstanceLookAndFeel.getCurrentGradientPainterName())) {
                    jmiGradientPainter.setSelected(true);
                }
                bgGradientPainter.add(jmiGradientPainter);
                gradientPainterMenu.add(jmiGradientPainter);
            }
            menu.add(gradientPainterMenu);
            this.gradientPainterChangeListener = new GradientPainterChangeListener(){

                public void gradientPainterChanged() {
                    SubstanceTitlePane.this.gradientPainterMenuHandler.selectTraitButton(SubstanceLookAndFeel.getCurrentGradientPainter());
                }
            };
            SubstanceLookAndFeel.registerGradientPainterChangeListener(this.gradientPainterChangeListener);
            JMenu titlePainterMenu = new JMenu(SubstanceCoreUtilities.getResourceBundle(this.rootPane).getString("SystemMenu.titlePainters"));
            ButtonGroup bgTitlePainter = new ButtonGroup();
            this.titlePainterMenuHandler = new TraitMenuHandler();
            Map<String, TitlePainterInfo> allTitlePainters = SubstanceLookAndFeel.getAllTitlePainters();
            for (Map.Entry<String, TitlePainterInfo> titlePainterEntry : allTitlePainters.entrySet()) {
                final String titlePainterClassName = titlePainterEntry.getValue().getClassName();
                JRadioButtonMenuItem jmiTitlePainter = new JRadioButtonMenuItem(titlePainterEntry.getKey());
                this.titlePainterMenuHandler.addTraitButton(titlePainterEntry.getValue().getDisplayName(), jmiTitlePainter);
                jmiTitlePainter.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                SubstanceLookAndFeel.setCurrentTitlePainter(titlePainterClassName);
                                for (Frame frame : Frame.getFrames()) {
                                    SwingUtilities.updateComponentTreeUI(frame);
                                }
                            }
                        });
                    }
                });
                if (titlePainterEntry.getKey().equals(SubstanceLookAndFeel.getCurrentTitlePainterName())) {
                    jmiTitlePainter.setSelected(true);
                }
                bgTitlePainter.add(jmiTitlePainter);
                titlePainterMenu.add(jmiTitlePainter);
            }
            menu.add(titlePainterMenu);
            this.titlePainterChangeListener = new TitlePainterChangeListener(){

                public void titlePainterChanged() {
                    SubstanceTitlePane.this.titlePainterMenuHandler.selectTraitButton(SubstanceLookAndFeel.getCurrentTitlePainter());
                }
            };
            SubstanceLookAndFeel.registerTitlePainterChangeListener(this.titlePainterChangeListener);
            if (canHaveHeapStatusPanel && !(this.rootPane.getClientProperty(HEAP_STATUS_PANEL_PERMANENT) instanceof Boolean)) {
                this.heapStatusMenuItem = new JCheckBoxMenuItem(SubstanceCoreUtilities.getResourceBundle(this.rootPane).getString("SystemMenu.showHeapStatus"));
                boolean isHeapStatusPanelShowing = Boolean.TRUE.equals(this.rootPane.getClientProperty("substancelaf.heapStatusPanel"));
                this.heapStatusMenuItem.setSelected(isHeapStatusPanelShowing);
                this.heapStatusMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        SubstanceTitlePane.this.heapStatusPanel.setVisible(!SubstanceTitlePane.this.heapStatusPanel.isVisible());
                        SubstanceTitlePane.this.rootPane.putClientProperty("substancelaf.heapStatusPanel", SubstanceTitlePane.this.heapStatusPanel.isVisible());
                    }
                });
                menu.add(this.heapStatusMenuItem);
            }
        }
        menu.addSeparator();
        menu.add(this.closeAction);
    }

    private JButton createTitleButton() {
        SubstanceTitleButton button = new SubstanceTitleButton();
        button.setFocusPainted(false);
        button.setFocusable(false);
        button.setOpaque(true);
        return button;
    }

    private void createButtons() {
        SubstanceTheme iconTheme = SubstanceLookAndFeel.getTheme().getActiveTitlePaneTheme();
        this.closeButton = this.createTitleButton();
        this.closeButton.setAction(this.closeAction);
        this.closeButton.setText(null);
        this.closeButton.putClientProperty("paintActive", Boolean.TRUE);
        this.closeButton.setBorder(null);
        TransitionAwareIcon closeIcon = new TransitionAwareIcon(this.closeButton, new TransitionAwareIcon.Delegate(){

            public Icon getThemeIcon(SubstanceTheme theme) {
                return SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.CLOSE, theme);
            }
        });
        this.closeButton.setIcon(closeIcon);
        this.closeButton.setFocusable(false);
        this.closeButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        this.closeButton.putClientProperty("substancelaf.internal.isTitleCloseButton", Boolean.TRUE);
        if (this.getWindowDecorationStyle() == 1) {
            this.minimizeButton = this.createTitleButton();
            this.minimizeButton.setAction(this.iconifyAction);
            this.minimizeButton.setText(null);
            this.minimizeButton.putClientProperty("paintActive", Boolean.TRUE);
            this.minimizeButton.setBorder(null);
            TransitionAwareIcon minIcon = new TransitionAwareIcon(this.minimizeButton, new TransitionAwareIcon.Delegate(){

                public Icon getThemeIcon(SubstanceTheme theme) {
                    return SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.MINIMIZE, theme);
                }
            });
            this.minimizeButton.setIcon(minIcon);
            this.minimizeButton.setFocusable(false);
            this.minimizeButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
            this.minimizeButton.setToolTipText(SubstanceCoreUtilities.getResourceBundle(this.rootPane).getString("SystemMenu.iconify"));
            this.toggleButton = this.createTitleButton();
            this.toggleButton.setAction(this.restoreAction);
            this.toggleButton.putClientProperty("paintActive", Boolean.TRUE);
            this.toggleButton.setBorder(null);
            this.toggleButton.setText(null);
            TransitionAwareIcon maxIcon = new TransitionAwareIcon(this.toggleButton, new TransitionAwareIcon.Delegate(){

                public Icon getThemeIcon(SubstanceTheme theme) {
                    return SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.MAXIMIZE, theme);
                }
            });
            this.toggleButton.setIcon(maxIcon);
            this.toggleButton.setToolTipText(SubstanceCoreUtilities.getResourceBundle(this.rootPane).getString("SystemMenu.maximize"));
            this.toggleButton.setFocusable(false);
            this.toggleButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        }
        this.syncCloseButtonTooltip();
    }

    private LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    private void setActive(boolean isActive) {
        Boolean activeB;
        Boolean bl = activeB = isActive ? Boolean.TRUE : Boolean.FALSE;
        if (this.getWindowDecorationStyle() == 1) {
            this.closeButton.putClientProperty("paintActive", activeB);
            this.minimizeButton.putClientProperty("paintActive", activeB);
            this.toggleButton.putClientProperty("paintActive", activeB);
        }
        this.getRootPane().repaint();
    }

    private void setState(int state) {
        this.setState(state, false);
    }

    private void setState(int state, boolean updateRegardless) {
        Window w = this.getWindow();
        if (w != null && this.getWindowDecorationStyle() == 1) {
            if (this.state == state && !updateRegardless) {
                return;
            }
            Frame frame = this.getFrame();
            if (frame != null) {
                JRootPane rootPane = this.getRootPane();
                if ((state & 6) != 0 && (rootPane.getBorder() == null || rootPane.getBorder() instanceof UIResource) && frame.isShowing()) {
                    rootPane.setBorder(null);
                } else if ((state & 6) == 0) {
                    this.rootPaneUI.installBorder(rootPane);
                }
                if (frame.isResizable()) {
                    SubstanceTheme iconTheme = SubstanceLookAndFeel.getTheme().getActiveTitlePaneTheme();
                    if ((state & 6) != 0) {
                        TransitionAwareIcon restoreIcon = new TransitionAwareIcon(this.toggleButton, new TransitionAwareIcon.Delegate(){

                            public Icon getThemeIcon(SubstanceTheme theme) {
                                return SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.RESTORE, theme);
                            }
                        });
                        this.updateToggleButton(this.restoreAction, restoreIcon);
                        this.toggleButton.setToolTipText(SubstanceCoreUtilities.getResourceBundle(rootPane).getString("SystemMenu.restore"));
                        this.maximizeAction.setEnabled(false);
                        this.restoreAction.setEnabled(true);
                    } else {
                        TransitionAwareIcon maxIcon = new TransitionAwareIcon(this.toggleButton, new TransitionAwareIcon.Delegate(){

                            public Icon getThemeIcon(SubstanceTheme theme) {
                                return SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.MAXIMIZE, theme);
                            }
                        });
                        this.updateToggleButton(this.maximizeAction, maxIcon);
                        this.toggleButton.setToolTipText(SubstanceCoreUtilities.getResourceBundle(rootPane).getString("SystemMenu.maximize"));
                        this.maximizeAction.setEnabled(true);
                        this.restoreAction.setEnabled(false);
                    }
                    if (this.toggleButton.getParent() == null || this.minimizeButton.getParent() == null) {
                        this.add(this.toggleButton);
                        this.add(this.minimizeButton);
                        this.revalidate();
                        this.repaint();
                    }
                    this.toggleButton.setText(null);
                } else {
                    this.maximizeAction.setEnabled(false);
                    this.restoreAction.setEnabled(false);
                    if (this.toggleButton.getParent() != null) {
                        this.remove(this.toggleButton);
                        this.revalidate();
                        this.repaint();
                    }
                }
            } else {
                this.maximizeAction.setEnabled(false);
                this.restoreAction.setEnabled(false);
                this.iconifyAction.setEnabled(false);
                this.remove(this.toggleButton);
                this.remove(this.minimizeButton);
                this.revalidate();
                this.repaint();
            }
            this.closeAction.setEnabled(true);
            this.state = state;
        }
    }

    private void updateToggleButton(Action action, Icon icon) {
        this.toggleButton.setAction(action);
        this.toggleButton.setIcon(icon);
        this.toggleButton.setText(null);
    }

    private Frame getFrame() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            return (Frame)window;
        }
        return null;
    }

    private Window getWindow() {
        return this.window;
    }

    private String getTitle() {
        Window w = this.getWindow();
        if (w instanceof Frame) {
            return ((Frame)w).getTitle();
        }
        if (w instanceof Dialog) {
            return ((Dialog)w).getTitle();
        }
        return null;
    }

    public void paintComponent(Graphics g) {
        String clippedTitle;
        int titleWidth;
        FontMetrics fm;
        Rectangle rect;
        int rightEnd;
        int leftEnd;
        if (this.getFrame() != null) {
            this.setState(this.getFrame().getExtendedState());
        }
        final JRootPane rootPane = this.getRootPane();
        Window window = this.getWindow();
        boolean leftToRight = window == null ? rootPane.getComponentOrientation().isLeftToRight() : window.getComponentOrientation().isLeftToRight();
        boolean isSelected = window == null ? true : window.isActive();
        final int width = this.getWidth();
        final int height = this.getHeight();
        final SubstanceTheme theme = isSelected ? SubstanceLookAndFeel.getTheme().getActiveTitlePaneTheme() : SubstanceLookAndFeel.getTheme().getDefaultTitlePaneTheme();
        int xOffset = 0;
        String theTitle = this.getTitle();
        if (leftToRight) {
            xOffset = 5;
            leftEnd = this.menuBar == null ? 0 : this.menuBar.getWidth() + 10;
            xOffset += leftEnd;
            JButton leftmostButton = null;
            if (this.minimizeButton != null && this.minimizeButton.getParent() != null && this.minimizeButton.getBounds().width != 0) {
                leftmostButton = this.minimizeButton;
            } else if (this.toggleButton != null && this.toggleButton.getParent() != null && this.toggleButton.getBounds().width != 0) {
                leftmostButton = this.toggleButton;
            } else if (this.closeButton != null && this.closeButton.getParent() != null) {
                leftmostButton = this.closeButton;
            }
            rightEnd = this.getWidth();
            if (leftmostButton != null) {
                rect = leftmostButton.getBounds();
                rightEnd = rect.getBounds().x - 5;
                if (this.heapStatusPanel != null && this.heapStatusPanel.isVisible()) {
                    rightEnd = this.heapStatusPanel.getBounds().x - 5;
                }
                --rightEnd;
            }
            if (theTitle != null) {
                fm = rootPane.getFontMetrics(g.getFont());
                clippedTitle = SubstanceCoreUtilities.clipString(fm, titleWidth = rightEnd - leftEnd - 20, theTitle);
                if (theTitle.equals(clippedTitle)) {
                    this.setToolTipText(null);
                } else {
                    this.setToolTipText(theTitle);
                }
                theTitle = clippedTitle;
            }
        } else {
            xOffset = width - 5;
            rightEnd = this.menuBar == null ? width - 5 : width - 5 - this.menuBar.getWidth() - 10;
            JButton rightmostButton = null;
            if (this.minimizeButton != null && this.minimizeButton.getParent() != null && this.minimizeButton.getBounds().width != 0) {
                rightmostButton = this.minimizeButton;
            } else if (this.toggleButton != null && this.toggleButton.getParent() != null && this.toggleButton.getBounds().width != 0) {
                rightmostButton = this.toggleButton;
            } else if (this.closeButton != null && this.closeButton.getParent() != null) {
                rightmostButton = this.closeButton;
            }
            leftEnd = 5;
            if (rightmostButton != null) {
                rect = rightmostButton.getBounds();
                leftEnd = (int)rect.getBounds().getMaxX() + 5;
                if (this.heapStatusPanel != null && this.heapStatusPanel.isVisible()) {
                    leftEnd = (int)this.heapStatusPanel.getBounds().getMaxX() + 5;
                }
                ++leftEnd;
            }
            if (theTitle != null) {
                fm = rootPane.getFontMetrics(g.getFont());
                clippedTitle = SubstanceCoreUtilities.clipString(fm, titleWidth = rightEnd - leftEnd - 20, theTitle);
                if (theTitle.equals(clippedTitle)) {
                    this.setToolTipText(null);
                } else {
                    this.setToolTipText(theTitle);
                }
                theTitle = clippedTitle;
                xOffset = rightEnd - fm.stringWidth(theTitle);
            }
        }
        final SubstanceTitlePainter titlePainter = SubstanceCoreUtilities.getTitlePainter(rootPane);
        Graphics2D graphics = (Graphics2D)g.create();
        FontUIResource font = SubstanceLookAndFeel.getFontPolicy().getFontSet("Substance", null).getWindowTitleFont();
        graphics.setFont(font);
        SubstanceTextPainter textPainter = SubstanceLookAndFeel.getCurrentTextPainter();
        if (textPainter.needsBackgroundImage()) {
            final int finalLeftEnd = leftEnd;
            final int finalRightEnd = rightEnd;
            textPainter.setBackgroundImage(this, null, null, false, 0, 0, new SubstanceTextPainter.BackgroundPaintingCallback(){

                public void paintBackground(Graphics g) {
                    Graphics2D graphics = (Graphics2D)g.create();
                    titlePainter.paintTitleBackground(graphics, rootPane, width + 1, height, finalLeftEnd, finalRightEnd, theme, 0.0f);
                    if (SubstanceCoreUtilities.toDrawWatermark(SubstanceTitlePane.this)) {
                        SubstanceLookAndFeel.getCurrentWatermark().drawWatermarkImage(graphics, SubstanceTitlePane.this, 0, 0, width, height);
                        Composite oldComp = graphics.getComposite();
                        graphics.setComposite(TransitionLayout.getAlphaComposite((Component)rootPane, 0.5f));
                        titlePainter.paintTitleBackground(graphics, rootPane, width + 1, height, finalLeftEnd, finalRightEnd, theme, 0.0f);
                        graphics.setComposite(oldComp);
                    }
                    graphics.dispose();
                }
            });
        } else {
            titlePainter.paintTitleBackground(graphics, rootPane, width + 1, height, leftEnd, rightEnd, theme, 0.0f);
            if (SubstanceCoreUtilities.toDrawWatermark(this)) {
                SubstanceLookAndFeel.getCurrentWatermark().drawWatermarkImage(graphics, this, 0, 0, width, height);
                Composite oldComp = graphics.getComposite();
                graphics.setComposite(TransitionLayout.getAlphaComposite((Component)this.rootPane, 0.5f));
                titlePainter.paintTitleBackground(graphics, rootPane, width + 1, height, leftEnd, rightEnd, theme, 0.0f);
                graphics.setComposite(oldComp);
            }
        }
        if (theTitle != null) {
            FontMetrics fm2 = rootPane.getFontMetrics(graphics.getFont());
            int yOffset = (height - fm2.getHeight()) / 2 + fm2.getAscent();
            SubstanceCoreUtilities.paintTextWithDropShadow(this, graphics, theme.getForegroundColor(), theTitle, width, height, xOffset, yOffset);
        }
        GhostPaintingUtils.paintGhostImages(this, graphics);
        graphics.dispose();
    }

    public static void setCanHaveHeapStatusPanel(boolean canHaveHeapStatusPanel) {
        SubstanceTitlePane.canHaveHeapStatusPanel = canHaveHeapStatusPanel;
    }

    public static boolean getCanHaveHeapStatusPanel() {
        return canHaveHeapStatusPanel;
    }

    public static void setHeapStatusLogfileName(String heapStatusLogfileName) {
        SubstanceTitlePane.heapStatusLogfileName = heapStatusLogfileName;
    }

    public void setHeapStatusPanePermanentVisibility(boolean isVisible) {
        if (!(this.rootPane.getClientProperty(HEAP_STATUS_PANEL_PERMANENT) instanceof Boolean)) {
            this.menuBar.getMenu(0).remove(this.heapStatusMenuItem);
            this.heapStatusMenuItem = null;
        }
        this.heapStatusPanel.setVisible(isVisible);
        this.rootPane.putClientProperty(HEAP_STATUS_PANEL_PERMANENT, isVisible);
        this.rootPane.putClientProperty("substancelaf.heapStatusPanel", isVisible);
        if (!isVisible) {
            HeapStatusThread.unregisterPanel(this.heapStatusPanel);
        }
        this.repaint();
    }

    protected void syncCloseButtonTooltip() {
        if (SubstanceCoreUtilities.isRootPaneModified(this.getRootPane())) {
            this.closeButton.setToolTipText(SubstanceCoreUtilities.getResourceBundle(this.rootPane).getString("SystemMenu.close") + " [" + SubstanceCoreUtilities.getResourceBundle(this.rootPane).getString("Tooltip.contentsNotSaved") + "]");
        } else {
            this.closeButton.setToolTipText(SubstanceCoreUtilities.getResourceBundle(this.rootPane).getString("SystemMenu.close"));
        }
        this.closeButton.repaint();
    }

    public static void dump(Component comp, int level) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            sb.append("  ");
        }
        sb.append(comp.toString());
        System.out.println(sb);
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                SubstanceTitlePane.dump(cont.getComponent(i), level + 1);
            }
        }
    }

    protected static class FocusKindChanger
    implements ActionListener {
        protected SubstanceConstants.FocusKind newFocusKind;

        public FocusKindChanger(SubstanceConstants.FocusKind newFocusKind) {
            this.newFocusKind = newFocusKind;
        }

        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    UIManager.put("substancelaf.focusKind", (Object)FocusKindChanger.this.newFocusKind);
                }
            });
        }
    }

    protected static class AnimationChanger
    implements ActionListener {
        protected LafConstants.AnimationKind newAnimationKind;

        public AnimationChanger(LafConstants.AnimationKind newAnimationKind) {
            this.newAnimationKind = newAnimationKind;
        }

        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    UIManager.put("lafwidgets.animationKind", AnimationChanger.this.newAnimationKind);
                }
            });
        }
    }

    protected static class ThemeChanger
    implements ActionListener {
        protected SubstanceTheme newTheme;

        public ThemeChanger(SubstanceTheme newTheme) {
            this.newTheme = newTheme;
        }

        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SubstanceLookAndFeel.setCurrentTheme(ThemeChanger.this.newTheme);
                    for (Frame frame : Frame.getFrames()) {
                        SwingUtilities.updateComponentTreeUI(frame);
                    }
                }
            });
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        public void windowActivated(WindowEvent ev) {
            SubstanceTitlePane.this.setActive(true);
        }

        public void windowDeactivated(WindowEvent ev) {
            SubstanceTitlePane.this.setActive(false);
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent pce) {
            String name = pce.getPropertyName();
            if ("resizable".equals(name) || "state".equals(name)) {
                Frame frame = SubstanceTitlePane.this.getFrame();
                if (frame != null) {
                    SubstanceTitlePane.this.setState(frame.getExtendedState(), true);
                }
                if ("resizable".equals(name)) {
                    SubstanceTitlePane.this.getRootPane().repaint();
                }
            } else if ("title".equals(name)) {
                SubstanceTitlePane.this.repaint();
                SubstanceTitlePane.this.setToolTipText((String)pce.getNewValue());
            } else if ("componentOrientation".equals(name) || "iconImage".equals(name)) {
                SubstanceTitlePane.this.revalidate();
                SubstanceTitlePane.this.repaint();
            }
        }
    }

    private class TitlePaneLayout
    implements LayoutManager {
        private TitlePaneLayout() {
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            int height = this.computeHeight();
            return new Dimension(height, height);
        }

        private int computeHeight() {
            FontMetrics fm = SubstanceTitlePane.this.rootPane.getFontMetrics(SubstanceTitlePane.this.getFont());
            int fontHeight = fm.getHeight();
            fontHeight += 7;
            int iconHeight = 0;
            if (SubstanceTitlePane.this.getWindowDecorationStyle() == 1) {
                iconHeight = SubstanceSizeUtils.getTitlePaneIconSize();
            }
            int finalHeight = Math.max(fontHeight, iconHeight);
            return finalHeight;
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        public void layoutContainer(Container c) {
            int buttonWidth;
            int buttonHeight;
            boolean leftToRight = SubstanceTitlePane.this.window == null ? SubstanceTitlePane.this.getRootPane().getComponentOrientation().isLeftToRight() : SubstanceTitlePane.this.window.getComponentOrientation().isLeftToRight();
            int w = SubstanceTitlePane.this.getWidth();
            int y = 3;
            if (SubstanceTitlePane.this.closeButton != null && SubstanceTitlePane.this.closeButton.getIcon() != null) {
                buttonHeight = SubstanceTitlePane.this.closeButton.getIcon().getIconHeight();
                buttonWidth = SubstanceTitlePane.this.closeButton.getIcon().getIconWidth();
            } else {
                buttonHeight = SubstanceSizeUtils.getTitlePaneIconSize();
                buttonWidth = SubstanceSizeUtils.getTitlePaneIconSize();
            }
            y = (SubstanceTitlePane.this.getHeight() - buttonHeight) / 2;
            int x = leftToRight ? w : 0;
            int spacing = 5;
            int n = x = leftToRight ? spacing : w - buttonWidth - spacing;
            if (SubstanceTitlePane.this.menuBar != null) {
                SubstanceTitlePane.this.menuBar.setBounds(x, y, buttonWidth, buttonHeight);
            }
            x = leftToRight ? w : 0;
            spacing = 4;
            x += leftToRight ? -spacing - buttonWidth : spacing;
            if (SubstanceTitlePane.this.closeButton != null) {
                SubstanceTitlePane.this.closeButton.setBounds(x, y, buttonWidth, buttonHeight);
            }
            if (!leftToRight) {
                x += buttonWidth;
            }
            if (SubstanceTitlePane.this.getWindowDecorationStyle() == 1) {
                if (Toolkit.getDefaultToolkit().isFrameStateSupported(6) && SubstanceTitlePane.this.toggleButton.getParent() != null) {
                    spacing = 10;
                    SubstanceTitlePane.this.toggleButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                    if (!leftToRight) {
                        x += buttonWidth;
                    }
                }
                if (SubstanceTitlePane.this.minimizeButton != null && SubstanceTitlePane.this.minimizeButton.getParent() != null) {
                    spacing = 2;
                    SubstanceTitlePane.this.minimizeButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                    if (!leftToRight) {
                        x += buttonWidth;
                    }
                }
                if (SubstanceTitlePane.this.heapStatusPanel != null && SubstanceTitlePane.this.heapStatusPanel.isVisible()) {
                    spacing = 5;
                    SubstanceTitlePane.this.heapStatusPanel.setBounds(x += leftToRight ? -spacing - SubstanceTitlePane.this.heapStatusPanel.getPreferredSize().width : spacing, 1, SubstanceTitlePane.this.heapStatusPanel.getPreferredSize().width, SubstanceTitlePane.this.getHeight() - 3);
                }
            }
        }
    }

    public class SubstanceMenuBar
    extends JMenuBar {
        public void paint(Graphics g) {
            Image image;
            Frame frame = SubstanceTitlePane.this.getFrame();
            Image image2 = image = frame != null ? frame.getIconImage() : null;
            if (image != null) {
                int iSize = SubstanceSizeUtils.getTitlePaneIconSize();
                double coef = Math.max((double)iSize / (double)image.getWidth(null), (double)iSize / (double)image.getHeight(null));
                if (coef < 1.0) {
                    BufferedImage bi = SubstanceCoreUtilities.getBlankImage(image.getWidth(null), image.getHeight(null));
                    bi.getGraphics().drawImage(image, 0, 0, null);
                    g.drawImage(LafWidgetUtilities.createThumbnail(bi, iSize), 0, 0, null);
                } else {
                    g.drawImage(image, 0, 0, null);
                }
            } else {
                Icon icon = UIManager.getIcon("InternalFrame.icon");
                if (icon != null) {
                    icon.paintIcon(this, g, 0, 0);
                }
            }
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            int iSize = SubstanceSizeUtils.getTitlePaneIconSize();
            return new Dimension(Math.max(iSize, size.width), Math.max(size.height, iSize));
        }
    }

    private class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super(SubstanceCoreUtilities.getResourceBundle(SubstanceTitlePane.this.rootPane).getString("SystemMenu.maximize"), SubstanceImageCreator.getMaximizeIcon(SubstanceLookAndFeel.getTheme()));
        }

        public void actionPerformed(ActionEvent e) {
            Frame frame = SubstanceTitlePane.this.getFrame();
            if (frame != null) {
                frame.setExtendedState(SubstanceTitlePane.this.state | 6);
            }
        }
    }

    private class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            super(SubstanceCoreUtilities.getResourceBundle(SubstanceTitlePane.this.rootPane).getString("SystemMenu.restore"), SubstanceImageCreator.getRestoreIcon(SubstanceLookAndFeel.getTheme()));
        }

        public void actionPerformed(ActionEvent e) {
            Frame frame = SubstanceTitlePane.this.getFrame();
            if (frame == null) {
                return;
            }
            if ((SubstanceTitlePane.this.state & 1) != 0) {
                frame.setExtendedState(SubstanceTitlePane.this.state & 0xFFFFFFFE);
            } else {
                frame.setExtendedState(SubstanceTitlePane.this.state & 0xFFFFFFF9);
            }
        }
    }

    private class IconifyAction
    extends AbstractAction {
        public IconifyAction() {
            super(SubstanceCoreUtilities.getResourceBundle(SubstanceTitlePane.this.rootPane).getString("SystemMenu.iconify"), SubstanceImageCreator.getMinimizeIcon(SubstanceLookAndFeel.getTheme()));
        }

        public void actionPerformed(ActionEvent e) {
            Frame frame = SubstanceTitlePane.this.getFrame();
            if (frame != null) {
                frame.setExtendedState(SubstanceTitlePane.this.state | 1);
            }
        }
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(SubstanceCoreUtilities.getResourceBundle(SubstanceTitlePane.this.rootPane).getString("SystemMenu.close"), SubstanceImageCreator.getCloseIcon(SubstanceLookAndFeel.getTheme()));
        }

        public void actionPerformed(ActionEvent e) {
            Window window = SubstanceTitlePane.this.getWindow();
            if (window != null) {
                window.dispatchEvent(new WindowEvent(window, 201));
            }
        }
    }

    public static class HeapStatusThread
    extends TrackableThread {
        private int heapSizeKB;
        private int takenHeapSizeKB;
        private static Set<WeakReference<HeapStatusPanel>> panels = new HashSet<WeakReference<HeapStatusPanel>>();
        private static HeapStatusThread instance;
        private SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
        private boolean isStopRequested = false;

        private HeapStatusThread() {
            this.setName("Substance heap status");
        }

        public static synchronized HeapStatusThread getInstance() {
            if (instance == null) {
                instance = new HeapStatusThread();
                instance.start();
            }
            return instance;
        }

        public static synchronized void registerPanel(HeapStatusPanel panel) {
            panels.add(new WeakReference<HeapStatusPanel>(panel));
        }

        public static synchronized void unregisterPanel(HeapStatusPanel panel) {
            Iterator<WeakReference<HeapStatusPanel>> it = panels.iterator();
            while (it.hasNext()) {
                WeakReference<HeapStatusPanel> ref = it.next();
                HeapStatusPanel currPanel = (HeapStatusPanel)ref.get();
                if (panel != currPanel) continue;
                it.remove();
                return;
            }
        }

        private synchronized void updateHeapCounts() {
            long heapSize = Runtime.getRuntime().totalMemory();
            long heapFreeSize = Runtime.getRuntime().freeMemory();
            this.heapSizeKB = (int)(heapSize / 1024L);
            this.takenHeapSizeKB = (int)((heapSize - heapFreeSize) / 1024L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.isStopRequested) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                this.updateHeapCounts();
                Iterator<WeakReference<HeapStatusPanel>> it = panels.iterator();
                while (it.hasNext()) {
                    WeakReference<HeapStatusPanel> refPanel = it.next();
                    HeapStatusPanel panel = (HeapStatusPanel)refPanel.get();
                    if (panel == null) {
                        panels.remove(it);
                        continue;
                    }
                    panel.updateStatus(this.heapSizeKB, this.takenHeapSizeKB);
                }
                if (heapStatusLogfileName == null) continue;
                PrintWriter pw = null;
                try {
                    pw = new PrintWriter(new FileWriter(heapStatusLogfileName, true));
                    pw.println(this.format.format(new Date()) + " " + this.takenHeapSizeKB + "KB / " + this.heapSizeKB + "KB");
                }
                catch (IOException iOException) {}
                continue;
                finally {
                    if (pw == null) continue;
                    pw.close();
                }
            }
        }

        protected void requestStop() {
            this.isStopRequested = true;
            instance = null;
        }
    }

    public static class HeapStatusPanel
    extends JPanel {
        private int currHeapSizeKB;
        private int currTakenHeapSizeKB;
        private LinkedList<Double> graphValues = new LinkedList();

        public HeapStatusPanel() {
            HeapStatusThread.getInstance();
        }

        public synchronized void updateStatus(int currHeapSizeKB, int currTakenHeapSizeKB) {
            this.currHeapSizeKB = currHeapSizeKB;
            this.currTakenHeapSizeKB = currTakenHeapSizeKB;
            double newGraphValue = (double)currTakenHeapSizeKB / (double)currHeapSizeKB;
            this.graphValues.addLast(newGraphValue);
            this.repaint();
        }

        public synchronized void paint(Graphics g) {
            Graphics2D graphics = (Graphics2D)g.create();
            ColorScheme scheme = SubstanceCoreUtilities.getActiveScheme(this.getRootPane());
            graphics.setColor(scheme.getDarkColor());
            int w = this.getWidth();
            int h = this.getHeight();
            graphics.drawRect(0, 0, w - 1, h - 1);
            graphics.setColor(scheme.getExtraLightColor());
            graphics.fillRect(1, 1, w - 2, h - 2);
            while (this.graphValues.size() > w - 2) {
                this.graphValues.removeFirst();
            }
            int xOff = w - this.graphValues.size() - 1;
            graphics.setColor(scheme.getMidColor());
            int count = 0;
            Iterator i$ = this.graphValues.iterator();
            while (i$.hasNext()) {
                double value = (Double)i$.next();
                int valueH = (int)(value * (double)(h - 2));
                graphics.drawLine(xOff + count, h - 1 - valueH, xOff + count, h - 2);
                ++count;
            }
            graphics.setFont(UIManager.getFont("Panel.font"));
            FontMetrics fm = graphics.getFontMetrics();
            StringBuffer longFormat = new StringBuffer();
            Formatter longFormatter = new Formatter(longFormat);
            longFormatter.format("%.1fMB / %.1fMB", Float.valueOf((float)this.currTakenHeapSizeKB / 1024.0f), Float.valueOf((float)this.currHeapSizeKB / 1024.0f));
            int strW = fm.stringWidth(longFormat.toString());
            int strH = fm.getAscent() + fm.getDescent();
            graphics.setColor(scheme.getForegroundColor());
            if (strW < w - 5) {
                graphics.drawString(longFormat.toString(), (w - strW) / 2, (h + strH) / 2 - 2);
            } else {
                String shortFormat = this.currTakenHeapSizeKB / 1024 + "MB / " + this.currHeapSizeKB / 1024 + "MB";
                strW = fm.stringWidth(shortFormat);
                graphics.drawString(shortFormat, (w - strW) / 2, (h + strH) / 2 - 2);
            }
            graphics.dispose();
        }
    }
}

