/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils.menu;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.View;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceMenu;
import org.jvnet.substance.SubstanceMenuBackgroundDelegate;
import org.jvnet.substance.painter.text.SubstanceTextPainter;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class MenuUtilities {
    private static SubstanceMenuBackgroundDelegate backgroundDelegate = new SubstanceMenuBackgroundDelegate(0.4f);
    static final StringBuffer MAX_ICON_OFFSET = new StringBuffer("maxIconOffset");
    static final StringBuffer MAX_TEXT_OFFSET = new StringBuffer("maxTextOffset");

    public static int getTextOffset(Graphics g, Component menuItemParent) {
        if (!(menuItemParent instanceof JPopupMenu)) {
            return 0;
        }
        return MenuUtilities.getTextOffset(g, null, menuItemParent);
    }

    private static int getSingleItemTextOffset(Graphics g, JMenuItem menuItem) {
        Object prop = menuItem.getClientProperty("substancelaf.internal.singleMenuTextOffset");
        if (prop instanceof Integer) {
            return (Integer)prop;
        }
        SubstanceMenu ui = (SubstanceMenu)((Object)menuItem.getUI());
        int result = MenuUtilities.getTextOffset(g, menuItem, ui.getAcceleratorFont(), ui.getCheckIcon(), ui.getArrowIcon(), ui.getDefaultTextIconGap());
        menuItem.putClientProperty("substancelaf.internal.singleMenuTextOffset", result);
        return result;
    }

    public static int getTextOffset(Graphics g, JMenuItem menuItem) {
        return MenuUtilities.getTextOffset(g, menuItem, menuItem.getParent());
    }

    public static int getTextOffset(Graphics g, JMenuItem menuItem, Component parent) {
        if (!(parent instanceof JPopupMenu)) {
            return MenuUtilities.getSingleItemTextOffset(g, menuItem);
        }
        JPopupMenu popupMenu = (JPopupMenu)parent;
        Object prop = popupMenu.getClientProperty("substancelaf.internal.singleMenuTextOffset");
        if (prop instanceof Integer) {
            return (Integer)prop;
        }
        int maxTextOffset = -1;
        int maxIconWidth = 0;
        int maxIconX = 0;
        int maxCheckIconX = 0;
        int maxCheckIconWidth = 0;
        for (int i = 0; i < popupMenu.getComponentCount(); ++i) {
            JMenuItem childMenuItem;
            ButtonUI bui;
            Component comp = popupMenu.getComponent(i);
            if (!(comp instanceof JMenuItem) || !((bui = (childMenuItem = (JMenuItem)comp).getUI()) instanceof SubstanceMenu)) continue;
            SubstanceMenu ui = (SubstanceMenu)((Object)bui);
            MenuLayoutInfo mli = MenuUtilities.getMenuLayoutInfo(g, childMenuItem, ui.getAcceleratorFont(), ui.getCheckIcon(), ui.getArrowIcon(), ui.getDefaultTextIconGap());
            if (popupMenu.getComponentOrientation().isLeftToRight()) {
                if (mli.textRect != null) {
                    maxTextOffset = Math.max(maxTextOffset, mli.textRect.x);
                }
                if (mli.iconRect != null) {
                    maxIconWidth = Math.max(maxIconWidth, mli.iconRect.width + ui.getDefaultTextIconGap());
                    maxIconX = Math.max(maxIconX, mli.iconRect.x);
                }
                if (mli.checkIconRect == null) continue;
                maxCheckIconWidth = Math.max(maxCheckIconWidth, mli.checkIconRect.width + 2 * ui.getDefaultTextIconGap());
                maxCheckIconX = Math.max(maxCheckIconX, mli.checkIconRect.x);
                continue;
            }
            if (mli.textRect != null) {
                maxTextOffset = Math.max(maxTextOffset, mli.viewRect.x + mli.viewRect.width - (mli.textRect.x + mli.textRect.width));
            }
            if (mli.iconRect != null) {
                maxIconWidth = Math.max(maxIconWidth, mli.iconRect.width + 2 * ui.getDefaultTextIconGap());
                maxIconX = Math.max(maxIconX, mli.iconRect.x + mli.iconRect.width);
            }
            if (mli.checkIconRect == null) continue;
            maxCheckIconWidth = Math.max(maxCheckIconWidth, mli.checkIconRect.width + ui.getDefaultTextIconGap());
            maxCheckIconX = Math.max(maxCheckIconX, mli.checkIconRect.x + mli.checkIconRect.width);
        }
        int maxOffset = Math.max(maxTextOffset, maxIconWidth + maxCheckIconWidth);
        if (popupMenu.getComponentOrientation().isLeftToRight()) {
            maxOffset = Math.max(maxOffset, maxIconX + maxIconWidth);
            maxOffset = Math.max(maxOffset, maxCheckIconX + maxCheckIconWidth);
        }
        popupMenu.putClientProperty("substancelaf.internal.singleMenuTextOffset", maxOffset);
        return maxOffset;
    }

    public static int getTextOffset(Graphics g, JMenuItem menuItem, Font acceleratorFont, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        Insets i = menuItem.getInsets();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Rectangle acceleratorRect = new Rectangle();
        Rectangle checkIconRect = new Rectangle();
        Rectangle arrowIconRect = new Rectangle();
        Rectangle viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        if (menuWidth > 0 && menuHeight > 0) {
            viewRect.setBounds(0, 0, menuWidth, menuHeight);
        }
        viewRect.x += i.left;
        viewRect.y += i.top;
        viewRect.width -= i.right + viewRect.x;
        viewRect.height -= i.bottom + viewRect.y;
        Font f = menuItem.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics(f);
        FontMetrics fmAccel = g.getFontMetrics(acceleratorFont);
        KeyStroke accelerator = menuItem.getAccelerator();
        String acceleratorText = "";
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = acceleratorText + UIManager.getString("MenuItem.acceleratorDelimiter");
            }
            acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? acceleratorText + KeyEvent.getKeyText(keyCode) : acceleratorText + accelerator.getKeyChar();
        }
        MenuUtilities.layoutMenuItem(menuItem, fm, menuItem.getText(), fmAccel, acceleratorText, menuItem.getIcon(), checkIcon, arrowIcon, menuItem.getVerticalAlignment(), menuItem.getHorizontalAlignment(), menuItem.getVerticalTextPosition(), menuItem.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, menuItem.getText() == null ? 0 : defaultTextIconGap, defaultTextIconGap);
        if (menuItem.getComponentOrientation().isLeftToRight()) {
            return textRect.x;
        }
        return viewRect.x + viewRect.width - iconRect.x - (iconRect.width != 0 ? 0 : defaultTextIconGap);
    }

    private static MenuLayoutInfo getMenuLayoutInfo(Graphics g, JMenuItem menuItem, Font acceleratorFont, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        Insets i = menuItem.getInsets();
        Rectangle iconRect = new Rectangle(0, 0, 0, 0);
        Rectangle textRect = new Rectangle(0, 0, 0, 0);
        Rectangle acceleratorRect = new Rectangle(0, 0, 0, 0);
        Rectangle checkIconRect = new Rectangle(0, 0, 0, 0);
        Rectangle arrowIconRect = new Rectangle(0, 0, 0, 0);
        Rectangle viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        if (menuWidth > 0 && menuHeight > 0) {
            viewRect.setBounds(0, 0, menuWidth, menuHeight);
        }
        viewRect.x += i.left;
        viewRect.y += i.top;
        viewRect.width -= i.right + viewRect.x;
        viewRect.height -= i.bottom + viewRect.y;
        Font f = menuItem.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics(f);
        FontMetrics fmAccel = g.getFontMetrics(acceleratorFont);
        KeyStroke accelerator = menuItem.getAccelerator();
        String acceleratorText = "";
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = acceleratorText + UIManager.getString("MenuItem.acceleratorDelimiter");
            }
            acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? acceleratorText + KeyEvent.getKeyText(keyCode) : acceleratorText + accelerator.getKeyChar();
        }
        String text = MenuUtilities.layoutMenuItem(menuItem, fm, menuItem.getText(), fmAccel, acceleratorText, menuItem.getIcon(), checkIcon, arrowIcon, menuItem.getVerticalAlignment(), menuItem.getHorizontalAlignment(), menuItem.getVerticalTextPosition(), menuItem.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, menuItem.getText() == null ? 0 : defaultTextIconGap, defaultTextIconGap);
        MenuLayoutInfo mlInfo = new MenuLayoutInfo();
        mlInfo.checkIconRect = checkIconRect.width > 0 ? checkIconRect : null;
        mlInfo.iconRect = iconRect.width > 0 ? iconRect : null;
        mlInfo.textRect = textRect.width > 0 ? textRect : null;
        mlInfo.viewRect = viewRect.width > 0 ? viewRect : null;
        mlInfo.acceleratorRect = acceleratorRect;
        mlInfo.arrowIconRect = arrowIconRect;
        mlInfo.text = text;
        return mlInfo;
    }

    private static String layoutMenuItem(JMenuItem menuItem, FontMetrics fm, String text, FontMetrics fmAccel, String acceleratorText, Icon icon, Icon checkIcon, Icon arrowIcon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewRect, Rectangle iconRect, Rectangle textRect, Rectangle acceleratorRect, Rectangle checkIconRect, Rectangle arrowIconRect, int textIconGap, int menuItemGap) {
        SwingUtilities.layoutCompoundLabel(menuItem, fm, text, icon, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewRect, iconRect, textRect, textIconGap);
        if (acceleratorText == null || acceleratorText.equals("")) {
            acceleratorRect.height = 0;
            acceleratorRect.width = 0;
            acceleratorText = "";
        } else {
            acceleratorRect.width = fmAccel.stringWidth(acceleratorText);
            acceleratorRect.height = fmAccel.getHeight();
        }
        if (MenuUtilities.useCheckAndArrow(menuItem)) {
            if (checkIcon != null) {
                checkIconRect.width = checkIcon.getIconWidth();
                checkIconRect.height = checkIcon.getIconHeight();
            } else {
                checkIconRect.height = 0;
                checkIconRect.width = 0;
            }
            if (arrowIcon != null) {
                arrowIconRect.width = arrowIcon.getIconWidth();
                arrowIconRect.height = arrowIcon.getIconHeight();
            } else {
                arrowIconRect.height = 0;
                arrowIconRect.width = 0;
            }
        }
        Rectangle labelRect = iconRect.union(textRect);
        if (menuItem.getComponentOrientation().isLeftToRight()) {
            textRect.x += menuItemGap;
            iconRect.x += menuItemGap;
            acceleratorRect.x = viewRect.x + viewRect.width - arrowIconRect.width - menuItemGap - acceleratorRect.width;
            if (MenuUtilities.useCheckAndArrow(menuItem)) {
                checkIconRect.x = viewRect.x + menuItemGap;
                textRect.x += menuItemGap + checkIconRect.width;
                iconRect.x += menuItemGap + checkIconRect.width;
                arrowIconRect.x = viewRect.x + viewRect.width - menuItemGap - arrowIconRect.width;
            }
        } else {
            textRect.x -= menuItemGap;
            iconRect.x -= menuItemGap;
            acceleratorRect.x = viewRect.x + arrowIconRect.width + menuItemGap;
            if (MenuUtilities.useCheckAndArrow(menuItem)) {
                checkIconRect.x = viewRect.x + viewRect.width - menuItemGap - checkIconRect.width;
                textRect.x -= menuItemGap + checkIconRect.width;
                iconRect.x -= menuItemGap + checkIconRect.width;
                arrowIconRect.x = viewRect.x + menuItemGap;
            }
        }
        acceleratorRect.y = labelRect.y + labelRect.height / 2 - acceleratorRect.height / 2;
        if (MenuUtilities.useCheckAndArrow(menuItem)) {
            arrowIconRect.y = labelRect.y + labelRect.height / 2 - arrowIconRect.height / 2;
            checkIconRect.y = labelRect.y + labelRect.height / 2 - checkIconRect.height / 2;
        }
        return text;
    }

    private static boolean useCheckAndArrow(JMenuItem menuItem) {
        boolean b = true;
        if (menuItem instanceof JMenu && ((JMenu)menuItem).isTopLevelMenu()) {
            b = false;
        }
        return b;
    }

    private static JComponent getMenuItemParent(JMenuItem mi) {
        Container parent = mi.getParent();
        if (!(!(parent instanceof JComponent) || mi instanceof JMenu && ((JMenu)mi).isTopLevelMenu())) {
            return (JComponent)parent;
        }
        return null;
    }

    public static void lineupTextRectangle(Graphics g, JMenuItem menuItem, Rectangle textRect, int defaultTextIconGap) {
        int textOffset = MenuUtilities.getTextOffset(g, menuItem);
        if (menuItem.getComponentOrientation().isLeftToRight()) {
            textRect.setLocation(textOffset, textRect.y);
        } else {
            int loc = menuItem.getWidth() - textOffset - textRect.width - defaultTextIconGap;
            textRect.setLocation(loc, textRect.y);
        }
    }

    public static void paintMenuItem(Graphics g, JMenuItem menuItem, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        ButtonModel model = menuItem.getModel();
        SubstanceMenu menuUi = (SubstanceMenu)((Object)menuItem.getUI());
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        Insets i = menuItem.getInsets();
        Font holdf = g.getFont();
        Font f = menuItem.getFont();
        g.setFont(f);
        FontMetrics fm = menuItem.getFontMetrics(f);
        FontMetrics fmAccel = menuItem.getFontMetrics(menuUi.getAcceleratorFont());
        KeyStroke accelerator = menuItem.getAccelerator();
        String acceleratorText = "";
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = acceleratorText + UIManager.getString("MenuItem.acceleratorDelimiter");
            }
            acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? acceleratorText + KeyEvent.getKeyText(keyCode) : acceleratorText + accelerator.getKeyChar();
        }
        Icon icon = menuItem.getIcon();
        MenuLayoutInfo mli = MenuUtilities.getMenuLayoutInfo(g, menuItem, menuUi.getAcceleratorFont(), menuUi.getCheckIcon(), menuUi.getArrowIcon(), menuUi.getDefaultTextIconGap());
        MenuUtilities.lineupTextRectangle(g, menuItem, mli.textRect, defaultTextIconGap);
        MenuUtilities.paintBackground(g, menuItem, background);
        Color holdc = g.getColor();
        HashSet<SubstanceTextPainter.TextLineInfo> textLines = new HashSet<SubstanceTextPainter.TextLineInfo>();
        if (mli.text != null) {
            View v = (View)menuItem.getClientProperty("html");
            if (v != null) {
                v.paint(g, mli.textRect);
            } else {
                g.setFont(menuItem.getFont());
                textLines.add(new SubstanceTextPainter.TextLineInfo(mli.textRect, mli.text, menuItem.getDisplayedMnemonicIndex()));
            }
        }
        if (acceleratorText != null && !acceleratorText.equals("")) {
            int accOffset = 0;
            JComponent p = MenuUtilities.getMenuItemParent(menuItem);
            if (p != null) {
                int maxValue = mli.acceleratorRect.width;
                accOffset = maxValue - mli.acceleratorRect.width;
            }
            textLines.add(new SubstanceTextPainter.TextLineInfo(mli.acceleratorRect, acceleratorText, -1));
        }
        ComponentState state = ComponentState.getState(menuItem.getModel(), menuItem, true);
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setComposite(TransitionLayout.getAlphaComposite(menuItem, SubstanceCoreUtilities.getTheme(menuItem, true).getThemeAlpha(menuItem, state), g));
        SubstanceTextPainter textPainter = SubstanceLookAndFeel.getCurrentTextPainter();
        if (!state.isKindActive(FadeKind.ENABLE)) {
            graphics.setColor(UIManager.getColor("MenuItem.disabledForeground"));
        } else {
            ComponentState prevState = SubstanceCoreUtilities.getPrevComponentState(menuItem);
            Color fg = menuItem.getForeground();
            if (fg instanceof UIResource) {
                fg = SubstanceCoreUtilities.getInterpolatedForegroundColor(menuItem, null, SubstanceCoreUtilities.getHighlightTheme((Component)menuItem, menuItem.getParent(), state, true), state, prevState, FadeKind.ROLLOVER, FadeKind.PRESS, FadeKind.ARM, FadeKind.SELECTION);
            }
            graphics.setColor(fg);
        }
        textPainter.paintText(graphics, menuItem, textLines);
        graphics.dispose();
        if (checkIcon != null) {
            if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                g.setColor(foreground);
            } else {
                g.setColor(holdc);
            }
            if (MenuUtilities.useCheckAndArrow(menuItem)) {
                checkIcon.paintIcon(menuItem, g, mli.checkIconRect.x, mli.checkIconRect.y);
            }
            g.setColor(holdc);
        }
        if (icon != null) {
            if (!model.isEnabled()) {
                icon = menuItem.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                icon = menuItem.getPressedIcon();
                if (icon == null) {
                    icon = menuItem.getIcon();
                }
            } else {
                icon = menuItem.getIcon();
            }
            if (icon != null) {
                icon.paintIcon(menuItem, g, mli.iconRect.x, mli.iconRect.y);
                g.setColor(holdc);
            }
        }
        if (arrowIcon != null) {
            if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                g.setColor(foreground);
            }
            if (MenuUtilities.useCheckAndArrow(menuItem)) {
                arrowIcon.paintIcon(menuItem, g, mli.arrowIconRect.x, mli.arrowIconRect.y);
            }
        }
        g.setColor(holdc);
        g.setFont(holdf);
    }

    protected static void paintBackground(Graphics g, final JMenuItem menuItem, final Color bgColor) {
        int textOffset = MenuUtilities.getTextOffset(g, menuItem);
        SubstanceTextPainter textPainter = SubstanceLookAndFeel.getCurrentTextPainter();
        final int finalTextOffset = textOffset;
        SubstanceTextPainter.BackgroundPaintingCallback callback = new SubstanceTextPainter.BackgroundPaintingCallback(){

            public void paintBackground(Graphics g) {
                Graphics2D g2d = (Graphics2D)g.create();
                backgroundDelegate.paintBackground(g, menuItem, bgColor, 0.5f, finalTextOffset);
                g2d.dispose();
            }
        };
        if (textPainter.needsBackgroundImage()) {
            textPainter.setBackgroundImage(menuItem, null, bgColor, true, 0, 0, callback);
        } else {
            callback.paintBackground(g);
        }
    }

    public static class MenuLayoutInfo {
        public Rectangle viewRect;
        public Rectangle iconRect;
        public Rectangle checkIconRect;
        public Rectangle textRect;
        public Rectangle acceleratorRect;
        public Rectangle arrowIconRect;
        public String text;
    }

    public static class MenuPropertyListener
    implements PropertyChangeListener {
        protected JMenuItem menuItem;

        public MenuPropertyListener(JMenuItem menuItem) {
            this.menuItem = menuItem;
        }

        public void install() {
            this.menuItem.addPropertyChangeListener(this);
        }

        public void uninstall() {
            this.menuItem.removePropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (!evt.getPropertyName().equals("substancelaf.internal.singleMenuTextOffset")) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MenuPropertyListener.this.menuItem.putClientProperty("substancelaf.internal.singleMenuTextOffset", null);
                        if (MenuPropertyListener.this.menuItem.getParent() instanceof JPopupMenu) {
                            ((JPopupMenu)MenuPropertyListener.this.menuItem.getParent()).putClientProperty("substancelaf.internal.singleMenuTextOffset", null);
                        }
                    }
                });
            }
        }
    }
}

